/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.datatype;

import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.spi.type.Type;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import io.trino.testing.datatype.ColumnSetup;
import io.trino.testing.datatype.DataSetup;
import io.trino.testing.datatype.DataType;
import io.trino.testing.sql.TestTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.testng.Assert;

public class DataTypeTest {
    private static final Logger log = Logger.get(DataTypeTest.class);
    private final List<Input<?>> inputs = new ArrayList();
    private boolean runSelectWithWhere;

    private DataTypeTest(boolean runSelectWithWhere) {
        this.runSelectWithWhere = runSelectWithWhere;
    }

    public static DataTypeTest create() {
        return new DataTypeTest(false);
    }

    public static DataTypeTest create(boolean runSelectWithWhere) {
        return new DataTypeTest(runSelectWithWhere);
    }

    public <T> DataTypeTest addRoundTrip(DataType<T> dataType, T value) {
        return this.addRoundTrip(dataType, value, true);
    }

    public <T> DataTypeTest addRoundTrip(DataType<T> dataType, T value, boolean useInWhereClause) {
        this.inputs.add(new Input<T>(dataType, value, useInWhereClause));
        return this;
    }

    public void execute(QueryRunner trinoExecutor, DataSetup dataSetup) {
        this.execute(trinoExecutor, trinoExecutor.getDefaultSession(), dataSetup);
    }

    public void execute(QueryRunner trinoExecutor, Session session, DataSetup dataSetup) {
        List<Type> expectedTypes = this.inputs.stream().map(Input::getTrinoResultType).collect(Collectors.toList());
        List<Object> expectedResults = this.inputs.stream().map(Input::toTrinoQueryResult).collect(Collectors.toList());
        try (TestTable testTable = dataSetup.setupTestTable(Collections.unmodifiableList(this.inputs));){
            MaterializedResult materializedRows = trinoExecutor.execute(session, "SELECT * from " + testTable.getName());
            this.checkResults(expectedTypes, expectedResults, materializedRows);
            if (this.runSelectWithWhere) {
                this.queryWithWhere(trinoExecutor, session, expectedTypes, expectedResults, testTable);
            }
        }
    }

    private void queryWithWhere(QueryRunner trinoExecutor, Session session, List<Type> expectedTypes, List<Object> expectedResults, TestTable testTable) {
        String trinoQuery = this.buildTrinoQueryWithWhereClauses(testTable);
        try {
            MaterializedResult filteredRows = trinoExecutor.execute(session, trinoQuery);
            this.checkResults(expectedTypes, expectedResults, filteredRows);
        }
        catch (RuntimeException e) {
            log.error("Exception caught during query with merged WHERE clause, querying one column at a time", new Object[]{e});
            this.debugTypes(trinoExecutor, session, expectedTypes, expectedResults, testTable);
        }
    }

    private void debugTypes(QueryRunner trinoExecutor, Session session, List<Type> expectedTypes, List<Object> expectedResults, TestTable testTable) {
        for (int i = 0; i < this.inputs.size(); ++i) {
            Input<?> input = this.inputs.get(i);
            if (!input.isUseInWhereClause()) continue;
            String debugQuery = String.format("SELECT col_%d FROM %s WHERE col_%d IS NOT DISTINCT FROM %s", i, testTable.getName(), i, input.toTrinoLiteral());
            log.info("Querying input: %d (expected type: %s, expectedResult: %s) using: %s", new Object[]{i, expectedTypes.get(i), expectedResults.get(i), debugQuery});
            MaterializedResult debugRows = trinoExecutor.execute(session, debugQuery);
            this.checkResults(expectedTypes.subList(i, i + 1), expectedResults.subList(i, i + 1), debugRows);
        }
    }

    private String buildTrinoQueryWithWhereClauses(TestTable testTable) {
        ArrayList<String> predicates = new ArrayList<String>();
        for (int i = 0; i < this.inputs.size(); ++i) {
            Input<?> input = this.inputs.get(i);
            if (!input.isUseInWhereClause()) continue;
            predicates.add(String.format("col_%d IS NOT DISTINCT FROM %s", i, input.toTrinoLiteral()));
        }
        return "SELECT * FROM " + testTable.getName() + " WHERE " + String.join((CharSequence)" AND ", predicates);
    }

    private void checkResults(List<Type> expectedTypes, List<Object> expectedResults, MaterializedResult materializedRows) {
        Assertions.assertThat((List)materializedRows.getTypes()).isEqualTo(expectedTypes);
        List actualResults = ((MaterializedRow)Iterables.getOnlyElement((Iterable)materializedRows)).getFields();
        Verify.verify((actualResults.size() == expectedResults.size() ? 1 : 0) != 0, (String)"lists don't have the same size", (Object[])new Object[0]);
        for (int i = 0; i < expectedResults.size(); ++i) {
            Assert.assertEquals(actualResults.get(i), (Object)expectedResults.get(i), (String)("Element " + i));
        }
    }

    public static class Input<T>
    implements ColumnSetup {
        private final DataType<T> dataType;
        private final T value;
        private final boolean useInWhereClause;

        public Input(DataType<T> dataType, T value, boolean useInWhereClause) {
            this.dataType = dataType;
            this.value = value;
            this.useInWhereClause = useInWhereClause;
        }

        public boolean isUseInWhereClause() {
            return this.useInWhereClause;
        }

        @Override
        public Optional<String> getDeclaredType() {
            return Optional.of(this.getInsertType());
        }

        public String getInsertType() {
            return this.dataType.getInsertType();
        }

        Type getTrinoResultType() {
            return this.dataType.getTrinoResultType();
        }

        Object toTrinoQueryResult() {
            return this.dataType.toTrinoQueryResult(this.value);
        }

        @Override
        public String getInputLiteral() {
            return this.toLiteral();
        }

        public String toLiteral() {
            return this.dataType.toLiteral(this.value);
        }

        public String toTrinoLiteral() {
            return this.dataType.toTrinoLiteral(this.value);
        }
    }
}

