/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.cost.StatsCalculator;
import io.trino.metadata.AllNodes;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.SessionPropertyManager;
import io.trino.metadata.SqlFunction;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.Plugin;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.testing.AbstractTestQueries;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingGroupProvider;
import io.trino.testing.TestingTrinoClient;
import io.trino.transaction.TransactionManager;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.intellij.lang.annotations.Language;

public final class StandaloneQueryRunner
implements QueryRunner {
    private final TestingTrinoServer server;
    private final TestingTrinoClient prestoClient;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public StandaloneQueryRunner(Session defaultSession) {
        Objects.requireNonNull(defaultSession, "defaultSession is null");
        this.server = StandaloneQueryRunner.createTestingTrinoServer();
        this.prestoClient = new TestingTrinoClient(this.server, defaultSession);
        this.refreshNodes();
        this.server.getMetadata().addFunctions(AbstractTestQueries.CUSTOM_FUNCTIONS);
        SessionPropertyManager sessionPropertyManager = this.server.getMetadata().getSessionPropertyManager();
        sessionPropertyManager.addSystemSessionProperties(AbstractTestQueries.TEST_SYSTEM_PROPERTIES);
        sessionPropertyManager.addConnectorSessionProperties(new CatalogName("catalog"), AbstractTestQueries.TEST_CATALOG_PROPERTIES);
    }

    public MaterializedResult execute(@Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.prestoClient.execute(sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MaterializedResult execute(Session session, @Language(value="SQL") String sql) {
        this.lock.readLock().lock();
        try {
            MaterializedResult materializedResult = (MaterializedResult)this.prestoClient.execute(session, sql).getResult();
            return materializedResult;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void close() {
        try {
            Closeables.closeAll((Closeable[])new Closeable[]{this.prestoClient, this.server});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getNodeCount() {
        return 1;
    }

    public Session getDefaultSession() {
        return this.prestoClient.getDefaultSession();
    }

    public TransactionManager getTransactionManager() {
        return this.server.getTransactionManager();
    }

    public Metadata getMetadata() {
        return this.server.getMetadata();
    }

    public SplitManager getSplitManager() {
        return this.server.getSplitManager();
    }

    public PageSourceManager getPageSourceManager() {
        return this.server.getPageSourceManager();
    }

    public NodePartitioningManager getNodePartitioningManager() {
        return this.server.getNodePartitioningManager();
    }

    public StatsCalculator getStatsCalculator() {
        return this.server.getStatsCalculator();
    }

    public TestingGroupProvider getGroupProvider() {
        return this.server.getGroupProvider();
    }

    public TestingAccessControlManager getAccessControl() {
        return this.server.getAccessControl();
    }

    public TestingTrinoServer getServer() {
        return this.server;
    }

    public void refreshNodes() {
        AllNodes allNodes;
        do {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while ((allNodes = this.server.refreshNodes()).getActiveNodes().isEmpty());
    }

    private void refreshNodes(CatalogName catalogName) {
        Set activeNodesWithConnector;
        do {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while ((activeNodesWithConnector = this.server.getActiveNodesWithConnector(catalogName)).isEmpty());
    }

    public void installPlugin(Plugin plugin) {
        this.server.installPlugin(plugin);
    }

    public void addFunctions(List<? extends SqlFunction> functions) {
        this.server.getMetadata().addFunctions(functions);
    }

    public void createCatalog(String catalogName, String connectorName) {
        this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        CatalogName catalog = this.server.createCatalog(catalogName, connectorName, properties);
        this.refreshNodes(catalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QualifiedObjectName> listTables(Session session, String catalog, String schema) {
        this.lock.readLock().lock();
        try {
            List<QualifiedObjectName> list = this.prestoClient.listTables(session, catalog, schema);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Session session, String table) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.prestoClient.tableExists(session, table);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Lock getExclusiveLock() {
        return this.lock.writeLock();
    }

    private static TestingTrinoServer createTestingTrinoServer() {
        return TestingTrinoServer.builder().setProperties((Map)ImmutableMap.builder().put((Object)"query.client.timeout", (Object)"10m").put((Object)"exchange.http-client.idle-timeout", (Object)"1h").put((Object)"node-scheduler.min-candidates", (Object)"1").build()).build();
    }
}

