/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.spi.type.TimeZoneKey;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryAssertions;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractTestAggregations
extends AbstractTestQueryFramework {
    @Test
    public void testCountBoolean() {
        this.assertQuery("SELECT COUNT(true) FROM orders");
    }

    @Test
    public void testCountAllWithComparison() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE tax < discount");
    }

    @Test
    public void testCountWithNotPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE NOT tax < discount");
    }

    @Test
    public void testCountWithNullPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE NULL");
    }

    @Test
    public void testCountWithIsNullPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM orders WHERE NULLIF(orderstatus, 'F') IS NULL", "SELECT COUNT(*) FROM orders WHERE orderstatus = 'F' ");
    }

    @Test
    public void testCountWithIsNotNullPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM orders WHERE NULLIF(orderstatus, 'F') IS NOT NULL", "SELECT COUNT(*) FROM orders WHERE orderstatus <> 'F' ");
    }

    @Test
    public void testCountWithNullIfPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM orders WHERE NULLIF(orderstatus, 'F') = orderstatus ");
    }

    @Test
    public void testAggregationPushdownThroughOuterJoinNotFiringInCorrelatedAggregatesLeftSide() {
        this.assertQuery("SELECT max(x) FROM(SELECT * from (VALUES 1) t(x) LEFT JOIN (VALUES 1) t2(y) ON t.x = t2.y)GROUP BY x", "VALUES 1");
    }

    @Test
    public void testAggregationPushdownThroughOuterJoinNotFiringInCorrelatedAggregatesRightSide() {
        this.assertQuery("SELECT max(y) FROM(SELECT * from (VALUES 1) t(x) LEFT JOIN (VALUES 1) t2(y) ON t.x = t2.y)GROUP BY y", "VALUES 1");
    }

    @Test
    public void testAggregationUsingOuterTableSymbols() {
        this.assertQuery("SELECT max_by(n.nationkey, r.regionkey) FROM (SELECT DISTINCT regionkey FROM region) r LEFT JOIN nation n ON n.regionkey = r.regionkey GROUP BY r.regionkey", "VALUES 16, 20, 21, 23, 24");
    }

    @Test
    public void testCountAllOverJoin() {
        this.assertQuery("SELECT count(*) FROM (SELECT DISTINCT a, b FROM (VALUES (1, 1), (1, 2)) l(a, b)) l LEFT JOIN (SELECT 1 a) r ON l.a = r.a GROUP BY l.a, l.b", "VALUES 1, 1");
    }

    @Test
    public void testCountWithCoalescePredicate() {
        this.assertQuery("SELECT COUNT(*) FROM orders WHERE COALESCE(NULLIF(orderstatus, 'F'), 'bar') = 'bar'", "SELECT COUNT(*) FROM orders WHERE orderstatus = 'F'");
    }

    @Test
    public void testCountWithAndPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE tax < discount AND tax > 0.01 AND discount < 0.05");
    }

    @Test
    public void testCountWithOrPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM lineitem WHERE tax < 0.01 OR discount > 0.05");
    }

    @Test
    public void testCountWithInlineView() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT orderkey FROM lineitem) x");
    }

    @Test
    public void testNestedCount() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT orderkey, COUNT(*) FROM lineitem GROUP BY orderkey) x");
    }

    @Test
    public void testGroupByOnSupersetOfPartitioning() {
        this.assertQuery("SELECT orderdate, c, count(*) FROM (SELECT orderdate, count(*) c FROM orders GROUP BY orderdate) GROUP BY orderdate, c");
    }

    @Test
    public void testSumOfNulls() {
        this.assertQuery("SELECT orderstatus, sum(CAST(NULL AS BIGINT)) FROM orders GROUP BY orderstatus");
    }

    @Test
    public void testCountAllWithPredicate() {
        this.assertQuery("SELECT COUNT(*) FROM orders WHERE orderstatus = 'F'");
    }

    @Test
    public void testGroupByArray() {
        this.assertQuery("SELECT col[1], count FROM (SELECT ARRAY[custkey] col, COUNT(*) count FROM orders GROUP BY 1 ORDER BY 1)", "SELECT custkey, COUNT(*) FROM orders GROUP BY custkey ORDER BY custkey");
    }

    @Test
    public void testGroupByMap() {
        this.assertQuery("SELECT col[1], count FROM (SELECT MAP(ARRAY[1], ARRAY[custkey]) col, COUNT(*) count FROM orders GROUP BY 1)", "SELECT custkey, COUNT(*) FROM orders GROUP BY custkey");
    }

    @Test
    public void testGroupByComplexMap() {
        this.assertQuery("SELECT MAP_KEYS(x)[1] FROM (VALUES MAP(ARRAY['a'], ARRAY[ARRAY[1]]), MAP(ARRAY['b'], ARRAY[ARRAY[2]])) t(x) GROUP BY x", "VALUES 'a', 'b'");
    }

    @Test
    public void testGroupByRow() {
        this.assertQuery("SELECT col.col1, count FROM (SELECT CAST(row(custkey, custkey) AS row(col0 bigint, col1 bigint)) col, COUNT(*) count FROM orders GROUP BY 1)", "SELECT custkey, COUNT(*) FROM orders GROUP BY custkey");
    }

    @Test
    public void testGroupByWithoutAggregation() {
        this.assertQuery("SELECT orderstatus FROM orders GROUP BY orderstatus");
    }

    @Test
    public void testNestedGroupByWithSameKey() {
        this.assertQuery("SELECT custkey, sum(t) FROM (SELECT custkey, count(*) t FROM orders GROUP BY custkey) GROUP BY custkey");
    }

    @Test
    public void testGroupByWithNulls() {
        this.assertQuery("SELECT key, COUNT(*) FROM (SELECT CASE   WHEN orderkey % 3 = 0 THEN NULL   WHEN orderkey % 5 = 0 THEN 0   ELSE orderkey   END AS key FROM lineitem) GROUP BY key");
    }

    @Test
    public void testHistogram() {
        this.assertQuery("SELECT lines, COUNT(*) FROM (SELECT orderkey, COUNT(*) lines FROM lineitem GROUP BY orderkey) U GROUP BY lines");
    }

    @Test
    public void testCountDistinct() {
        this.assertQuery("SELECT COUNT(DISTINCT custkey + 1) FROM orders", "SELECT COUNT(*) FROM (SELECT DISTINCT custkey + 1 FROM orders) t");
        this.assertQuery("SELECT COUNT(DISTINCT linenumber), COUNT(*) from lineitem where linenumber < 0");
    }

    @Test
    public void testDistinctGroupBy() {
        this.assertQuery("SELECT COUNT(DISTINCT clerk) AS count, orderdate FROM orders GROUP BY orderdate ORDER BY count, orderdate");
    }

    @Test
    public void testSingleDistinctOptimizer() {
        this.assertQuery("SELECT custkey, orderstatus, COUNT(DISTINCT orderkey) FROM orders GROUP BY custkey, orderstatus");
        this.assertQuery("SELECT custkey, orderstatus, COUNT(DISTINCT orderkey), SUM(DISTINCT orderkey) FROM orders GROUP BY custkey, orderstatus");
        this.assertQuery("SELECT custkey, COUNT(DISTINCT orderstatus) FROM (   SELECT orders.custkey AS custkey, orders.orderstatus AS orderstatus    FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.orderkey = lineitem.partkey    GROUP BY orders.custkey, orders.orderstatus) GROUP BY custkey");
        this.assertQuery("SELECT custkey, COUNT(DISTINCT orderkey), COUNT(DISTINCT orderstatus) FROM orders GROUP BY custkey");
        this.assertQuery("SELECT SUM(DISTINCT x) FROM (SELECT custkey, COUNT(DISTINCT orderstatus) x FROM orders GROUP BY custkey) t");
    }

    @Test
    public void testExtractDistinctAggregationOptimizer() {
        this.assertQuery("SELECT max(orderstatus), COUNT(orderkey), sum(DISTINCT orderkey) FROM orders");
        this.assertQuery("SELECT custkey, orderstatus, avg(shippriority), SUM(DISTINCT orderkey) FROM orders GROUP BY custkey, orderstatus");
        this.assertQuery("SELECT s, MAX(custkey), SUM(a) FROM (    SELECT custkey, avg(shippriority) AS a, SUM(DISTINCT orderkey) AS s FROM orders GROUP BY custkey, orderstatus) GROUP BY s");
        this.assertQuery("SELECT max(orderstatus), COUNT(DISTINCT orderkey), sum(DISTINCT orderkey) FROM orders");
        this.assertQuery("SELECT max(orderstatus), COUNT(DISTINCT shippriority), sum(DISTINCT orderkey) FROM orders");
        this.assertQuery("SELECT COUNT(tan(shippriority)), sum(DISTINCT orderkey) FROM orders");
        this.assertQuery("SELECT count(DISTINCT a), max(b) FROM (VALUES (row(1, 2), 3)) t(a, b)", "VALUES (1, 3)");
        this.assertQuery("SELECT shippriority, MAX(orderstatus), SUM(DISTINCT shippriority) FROM orders GROUP BY shippriority");
        this.assertQuery("SELECT shippriority, COUNT(shippriority), SUM(DISTINCT orderkey) FROM orders GROUP BY shippriority");
        this.assertQuery("SELECT shippriority, COUNT(shippriority), SUM(DISTINCT shippriority) FROM orders GROUP BY shippriority");
        this.assertQuery("SELECT clerk, shippriority, MAX(orderstatus), SUM(DISTINCT shippriority) FROM orders GROUP BY clerk, shippriority");
        this.assertQuery("SELECT clerk, shippriority, COUNT(shippriority), SUM(DISTINCT orderkey) FROM orders GROUP BY clerk, shippriority");
        this.assertQuery("SELECT clerk, shippriority, COUNT(shippriority), SUM(DISTINCT shippriority) FROM orders GROUP BY clerk, shippriority");
    }

    @Test
    public void testDistinctWhere() {
        this.assertQuery("SELECT COUNT(DISTINCT clerk) FROM orders WHERE LENGTH(clerk) > 5");
    }

    @Test
    public void testMultipleDifferentDistinct() {
        this.assertQuery("SELECT COUNT(DISTINCT orderstatus), SUM(DISTINCT custkey) FROM orders");
    }

    @Test
    public void testMultipleDistinct() {
        this.assertQuery("SELECT COUNT(DISTINCT custkey), SUM(DISTINCT custkey) FROM orders", "SELECT COUNT(*), SUM(custkey) FROM (SELECT DISTINCT custkey FROM orders) t");
    }

    @Test
    public void testComplexDistinct() {
        this.assertQuery("SELECT COUNT(DISTINCT custkey), SUM(DISTINCT custkey), SUM(DISTINCT custkey + 1.0E0), AVG(DISTINCT custkey), VARIANCE(DISTINCT custkey) FROM orders", "SELECT COUNT(*), SUM(custkey), SUM(custkey + 1.0), AVG(custkey), VARIANCE(custkey) FROM (SELECT DISTINCT custkey FROM orders) t");
    }

    @Test
    public void testAggregationFilter() {
        this.assertQuery("SELECT sum(x) FILTER (WHERE y > 4) FROM (VALUES (1, 3), (2, 4), (2, 4), (4, 5)) t (x, y)", "SELECT 4");
        this.assertQuery("SELECT sum(x) FILTER (WHERE x > 1), sum(y) FILTER (WHERE y > 4) FROM (VALUES (1, 3), (2, 4), (2, 4), (4, 5)) t (x, y)", "SELECT 8, 5");
        this.assertQuery("SELECT sum(x) FILTER (WHERE x > 1), sum(x) FROM (VALUES (1), (2), (2), (4)) t (x)", "SELECT 8, 9");
        this.assertQuery("SELECT count(*) FILTER (WHERE x > 1), sum(x) FROM (VALUES (1, 3), (2, 4), (2, 4), (4, 5)) t (x, y)", "SELECT 3, 9");
        this.assertQuery("SELECT count(*) FILTER (WHERE x > 1), count(DISTINCT y) FROM (VALUES (1, 10), (2, 10), (3, 10), (4, 20)) t (x, y)", "SELECT 3, 2");
        this.assertQuery("SELECT sum(b) FILTER (WHERE true) FROM (SELECT count(*) FILTER (WHERE true) AS b)", "SELECT 1");
        this.assertQuery("SELECT count(1) FILTER (WHERE orderstatus = 'O') FROM orders", "SELECT count(*) FROM orders WHERE orderstatus = 'O'");
        this.assertQuery("SELECT sum(x) FILTER (WHERE y > 5) FROM (VALUES (1, 3), (2, 4), (2, 4), (4, 5)) t (x, y)", "SELECT null");
        this.assertQuery("SELECT count(*) FILTER (WHERE x > 4), sum(x) FILTER (WHERE y > 5) FROM (VALUES (1, 3), (2, 4), (2, 4), (4, 5)) t (x, y)", "SELECT 0, null");
    }

    @Test
    public void testAggregationFilterWithSubquery() {
        this.assertQuery("WITH company AS (SELECT * FROM (VALUES (1, 10), (2, 20)) t(dep_id, salary)), department AS (SELECT 1 id) SELECT dep_id, sum(salary), sum(salary) FILTER (WHERE EXISTS (SELECT 1 FROM department WHERE department.id = company.dep_id)) FROM company GROUP BY dep_id", "VALUES (1, 10, 10), (2, 20, NULL)");
    }

    @Test
    public void testAggregationWithProjection() {
        this.assertQuery("SELECT sum(totalprice * 2) - sum(totalprice) FROM orders");
        this.assertQuery("SELECT sum(totalprice * 2) + sum(totalprice * 2) FROM orders");
    }

    @Test
    public void testSameInputToAggregates() {
        this.assertQuery("SELECT max(a), max(b) FROM (SELECT custkey a, custkey b FROM orders) x");
    }

    @Test
    public void testAggregationImplicitCoercion() {
        this.assertQuery("SELECT 1.0 / COUNT(*) FROM orders");
        this.assertQuery("SELECT custkey, 1.0 / COUNT(*) FROM orders GROUP BY custkey");
    }

    @Test
    public void testAggregationOverRightJoinOverSingleStreamProbe() {
        this.assertQueryOrdered("SELECT\n  value\nFROM\n(\n    SELECT\n        key\n    FROM\n        (VALUES 'match') AS a(key)\n        LEFT JOIN (SELECT * FROM (VALUES (0)) LIMIT 0) AS x(ignored)\n        ON TRUE\n    GROUP BY 1\n) a\nRIGHT JOIN\n(\n    VALUES\n    ('match', 'value'),\n    ('no-match', 'value')\n) AS b(key, value)\nON a.key = b.key\nGROUP BY 1\n", "VALUES 'value'");
    }

    @Test
    public void testAggregationPushedBelowOuterJoin() {
        this.assertQuery("SELECT * FROM nation n1 WHERE (n1.nationkey > ( SELECT avg(nationkey) FROM nation n2 WHERE n1.regionkey=n2.regionkey))");
        this.assertQuery("SELECT max(name), min(name), count(nationkey) + 1, count(nationkey) FROM (SELECT DISTINCT regionkey FROM region) AS r1 LEFT JOIN nation ON r1.regionkey = nation.regionkey GROUP BY r1.regionkey HAVING sum(nationkey) < 20");
        this.assertQuery("SELECT DISTINCT r1.regionkey FROM (SELECT regionkey FROM region INTERSECT SELECT regionkey FROM region WHERE regionkey < 4) AS r1 LEFT JOIN nation ON r1.regionkey = nation.regionkey");
        this.assertQuery("SELECT max(nationkey) FROM (SELECT regionkey FROM region EXCEPT SELECT regionkey FROM region WHERE regionkey < 4) AS r1 LEFT JOIN nation ON r1.regionkey = nation.regionkey GROUP BY r1.regionkey");
        this.assertQuery("SELECT max(nationkey) FROM (VALUES CAST (1 AS BIGINT)) v1(col1) LEFT JOIN nation ON v1.col1 = nation.regionkey GROUP BY v1.col1", "VALUES 24");
    }

    @Test
    public void testAggregationWithSomeArgumentCasts() {
        this.assertQuery("SELECT APPROX_PERCENTILE(0.1E0, x), AVG(x), MIN(x) FROM (values 1, 1, 1) t(x)", "SELECT 0.1, 1.0, 1");
    }

    @Test
    public void testAggregationWithHaving() {
        this.assertQuery("SELECT a, count(1) FROM (VALUES 1, 2, 3, 2) t(a) GROUP BY a HAVING count(1) > 1", "SELECT 2, 2");
    }

    @Test
    public void testGroupByRepeatedField() {
        this.assertQuery("SELECT sum(custkey) FROM orders GROUP BY orderstatus, orderstatus");
        this.assertQuery("SELECT count(*) FROM (SELECT orderstatus a, orderstatus b FROM orders) GROUP BY a, b");
    }

    @Test
    public void testGroupByMultipleFieldsWithPredicateOnAggregationArgument() {
        this.assertQuery("SELECT custkey, orderstatus, MAX(orderkey) FROM orders WHERE orderkey = 1 GROUP BY custkey, orderstatus");
    }

    @Test
    public void testReorderOutputsOfGroupByAggregation() {
        this.assertQuery("SELECT orderstatus, a, custkey, b FROM (SELECT custkey, orderstatus, -COUNT(*) a, MAX(orderkey) b FROM orders WHERE orderkey = 1 GROUP BY custkey, orderstatus) T");
    }

    @Test
    public void testGroupAggregationOverNestedGroupByAggregation() {
        this.assertQuery("SELECT sum(custkey), max(orderstatus), min(c) FROM (SELECT orderstatus, custkey, COUNT(*) c FROM orders GROUP BY orderstatus, custkey) T");
    }

    @Test
    public void testGroupByBetween() {
        this.assertQuery("SELECT orderkey BETWEEN 1 AND 100 FROM orders GROUP BY orderkey BETWEEN 1 AND 100 ");
        this.assertQuery("SELECT CAST(orderkey BETWEEN 1 AND 100 AS BIGINT) FROM orders GROUP BY orderkey");
        this.assertQuery("SELECT CAST(50 BETWEEN orderkey AND 100 AS BIGINT) FROM orders GROUP BY orderkey");
        this.assertQuery("SELECT CAST(50 BETWEEN 1 AND orderkey AS BIGINT) FROM orders GROUP BY orderkey");
    }

    @Test
    public void testGroupByOrdinal() {
        this.assertQuery("SELECT orderstatus, sum(totalprice) FROM orders GROUP BY 1", "SELECT orderstatus, sum(totalprice) FROM orders GROUP BY orderstatus");
    }

    @Test
    public void testGroupBySearchedCase() {
        this.assertQuery("SELECT CASE WHEN orderstatus = 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY CASE WHEN orderstatus = 'O' THEN 'a' ELSE 'b' END");
        this.assertQuery("SELECT CASE WHEN orderstatus = 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY 1", "SELECT CASE WHEN orderstatus = 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY CASE WHEN orderstatus = 'O' THEN 'a' ELSE 'b' END");
    }

    @Test
    public void testGroupBySearchedCaseNoElse() {
        this.assertQuery("SELECT CASE WHEN orderstatus = 'O' THEN 'a' END, count(*)\nFROM orders\nGROUP BY CASE WHEN orderstatus = 'O' THEN 'a' END");
        this.assertQuery("SELECT CASE WHEN orderstatus = 'O' THEN 'a' END, count(*)\nFROM orders\nGROUP BY 1", "SELECT CASE WHEN orderstatus = 'O' THEN 'a' END, count(*)\nFROM orders\nGROUP BY CASE WHEN orderstatus = 'O' THEN 'a' END");
        this.assertQuery("SELECT CASE WHEN true THEN orderstatus END, count(*)\nFROM orders\nGROUP BY orderstatus");
    }

    @Test
    public void testGroupByIf() {
        this.assertQuery("SELECT IF(orderkey between 1 and 5, 'orders', 'others'), sum(totalprice) FROM orders GROUP BY 1", "SELECT CASE WHEN orderkey BETWEEN 1 AND 5 THEN 'orders' ELSE 'others' END, sum(totalprice)\nFROM orders\nGROUP BY CASE WHEN orderkey BETWEEN 1 AND 5 THEN 'orders' ELSE 'others' END");
    }

    @Test
    public void testGroupByCase() {
        this.assertQuery("SELECT CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END");
        this.assertQuery("SELECT CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY 1", "SELECT CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END");
        this.assertQuery("SELECT CASE orderstatus WHEN 'O' THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY orderstatus");
        this.assertQuery("SELECT CASE 'O' WHEN orderstatus THEN 'a' ELSE 'b' END, count(*)\nFROM orders\nGROUP BY orderstatus");
        this.assertQuery("SELECT CASE 1 WHEN 1 THEN orderstatus ELSE 'x' END, count(*)\nFROM orders\nGROUP BY orderstatus");
        this.assertQuery("SELECT CASE 1 WHEN 1 THEN 'x' ELSE orderstatus END, count(*)\nFROM orders\nGROUP BY orderstatus");
    }

    @Test
    public void testGroupByCaseNoElse() {
        this.assertQuery("SELECT CASE orderstatus WHEN 'O' THEN 'a' END, count(*)\nFROM orders\nGROUP BY CASE orderstatus WHEN 'O' THEN 'a' END");
        this.assertQuery("SELECT CASE orderstatus WHEN 'O' THEN 'a' END, count(*)\nFROM orders\nGROUP BY orderstatus");
        this.assertQuery("SELECT CASE 'O' WHEN orderstatus THEN 'a' END, count(*)\nFROM orders\nGROUP BY orderstatus");
        this.assertQuery("SELECT CASE 1 WHEN 1 THEN orderstatus END, count(*)\nFROM orders\nGROUP BY orderstatus");
    }

    @Test
    public void testGroupByCast() {
        this.assertQuery("SELECT CAST(orderkey AS VARCHAR), count(*) FROM orders GROUP BY CAST(orderkey AS VARCHAR)");
        this.assertQuery("SELECT CAST(orderkey AS VARCHAR), count(*) FROM orders GROUP BY 1", "SELECT CAST(orderkey AS VARCHAR), count(*) FROM orders GROUP BY CAST(orderkey AS VARCHAR)");
        this.assertQuery("SELECT CAST(orderkey AS VARCHAR), count(*) FROM orders GROUP BY orderkey");
    }

    @Test
    public void testGroupByCoalesce() {
        this.assertQuery("SELECT COALESCE(orderkey, custkey), count(*) FROM orders GROUP BY COALESCE(orderkey, custkey)");
        this.assertQuery("SELECT COALESCE(orderkey, custkey), count(*) FROM orders GROUP BY 1", "SELECT COALESCE(orderkey, custkey), count(*) FROM orders GROUP BY COALESCE(orderkey, custkey)");
        this.assertQuery("SELECT COALESCE(orderkey, 1), count(*) FROM orders GROUP BY orderkey");
        this.assertQuery("SELECT COALESCE(1, orderkey), count(*) FROM orders GROUP BY orderkey");
    }

    @Test
    public void testGroupByNullIf() {
        this.assertQuery("SELECT NULLIF(orderkey, custkey), count(*) FROM orders GROUP BY NULLIF(orderkey, custkey)");
        this.assertQuery("SELECT NULLIF(orderkey, custkey), count(*) FROM orders GROUP BY 1", "SELECT NULLIF(orderkey, custkey), count(*) FROM orders GROUP BY NULLIF(orderkey, custkey)");
        this.assertQuery("SELECT NULLIF(orderkey, 1), count(*) FROM orders GROUP BY orderkey");
        this.assertQuery("SELECT NULLIF(1, orderkey), count(*) FROM orders GROUP BY orderkey");
    }

    @Test
    public void testGroupByExtract() {
        this.assertQuery("SELECT EXTRACT(YEAR FROM orderdate), count(*) FROM orders GROUP BY EXTRACT(YEAR FROM orderdate)");
        this.assertQuery("SELECT EXTRACT(YEAR FROM orderdate), count(*) FROM orders GROUP BY 1", "SELECT EXTRACT(YEAR FROM orderdate), count(*) FROM orders GROUP BY EXTRACT(YEAR FROM orderdate)");
        this.assertQuery("SELECT EXTRACT(YEAR FROM orderdate), count(*) FROM orders GROUP BY orderdate");
    }

    @Test
    public void testGroupByNullConstant() {
        this.assertQuery("SELECT count(*)\nFROM (\n  SELECT CAST(null AS VARCHAR) constant, orderdate\n  FROM orders\n) a\ngroup by constant, orderdate\n");
    }

    @Test
    public void test15WayGroupBy() {
        this.assertQuery("SELECT     orderkey + 1, orderkey + 2, orderkey + 3, orderkey + 4, orderkey + 5,     orderkey + 6, orderkey + 7, orderkey + 8, orderkey + 9, orderkey + 10,     count(*) FROM orders GROUP BY     orderkey + 1, orderkey + 2, orderkey + 3, orderkey + 4, orderkey + 5,     orderkey + 6, orderkey + 7, orderkey + 8, orderkey + 9, orderkey + 10");
    }

    @Test
    public void testApproximateCountDistinct() {
        this.assertQuery("SELECT approx_distinct(NULL)", "SELECT 0");
        this.assertQuery("SELECT approx_distinct(NULL, 0.023)", "SELECT 0");
        this.assertQuery("SELECT approx_distinct(orderdate) FROM orders", "SELECT 2443");
        this.assertQuery("SELECT approx_distinct(orderdate, 0.023) FROM orders", "SELECT 2443");
        this.assertQuery("SELECT approx_distinct(CAST(orderdate AS TIMESTAMP)) FROM orders", "SELECT 2379");
        this.assertQuery("SELECT approx_distinct(CAST(orderdate AS TIMESTAMP), 0.023) FROM orders", "SELECT 2379");
        this.assertQuery("SELECT approx_distinct(CAST(orderdate AS TIMESTAMP(9))) FROM orders", "SELECT 2393");
        this.assertQuery("SELECT approx_distinct(CAST(orderdate AS TIMESTAMP(9)), 0.023) FROM orders", "SELECT 2393");
        this.assertQuery("SELECT approx_distinct(CAST(orderdate AS TIMESTAMP WITH TIME ZONE)) FROM orders", "SELECT 2347");
        this.assertQuery("SELECT approx_distinct(CAST(orderdate AS TIMESTAMP WITH TIME ZONE), 0.023) FROM orders", "SELECT 2347");
        this.assertQuery("SELECT approx_distinct(CAST(orderdate AS TIMESTAMP(9) WITH TIME ZONE)) FROM orders", "SELECT 2322");
        this.assertQuery("SELECT approx_distinct(CAST(orderdate AS TIMESTAMP(9) WITH TIME ZONE), 0.023) FROM orders", "SELECT 2322");
        this.assertQuery("SELECT approx_distinct(CAST(from_unixtime(custkey) AS TIME)) FROM orders", "SELECT 969");
        this.assertQuery("SELECT approx_distinct(CAST(from_unixtime(custkey) AS TIME), 0.023) FROM orders", "SELECT 969");
        this.assertQuery("SELECT approx_distinct(CAST(from_unixtime(custkey) AS TIME(9))) FROM orders", "SELECT 969");
        this.assertQuery("SELECT approx_distinct(CAST(from_unixtime(custkey) AS TIME(9)), 0.023) FROM orders", "SELECT 969");
        Session session = Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"+08:35")).build();
        this.assertQuery(session, "SELECT approx_distinct(CAST(from_unixtime(custkey) AS TIME WITH TIME ZONE)) FROM orders", "SELECT 993");
        this.assertQuery(session, "SELECT approx_distinct(CAST(from_unixtime(custkey) AS TIME WITH TIME ZONE), 0.023) FROM orders", "SELECT 993");
        this.assertQuery(session, "SELECT approx_distinct(CAST(from_unixtime(custkey) AS TIME(12) WITH TIME ZONE)) FROM orders", "SELECT 1000");
        this.assertQuery(session, "SELECT approx_distinct(CAST(from_unixtime(custkey) AS TIME(12) WITH TIME ZONE), 0.023) FROM orders", "SELECT 1000");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS DECIMAL(18, 0))) FROM orders", "SELECT 990");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS DECIMAL(18, 0)), 0.023) FROM orders", "SELECT 990");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS DECIMAL(25, 20))) FROM orders", "SELECT 988");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS DECIMAL(25, 20)), 0.023) FROM orders", "SELECT 988");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS REAL)) FROM orders", "SELECT 1006");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS REAL), 0.023) FROM orders", "SELECT 1006");
        this.assertQuery("SELECT approx_distinct(custkey) FROM orders", "SELECT 990");
        this.assertQuery("SELECT approx_distinct(custkey, 0.023) FROM orders", "SELECT 990");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS INTEGER)) FROM orders", "SELECT 990");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS INTEGER), 0.023) FROM orders", "SELECT 990");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS SMALLINT)) FROM orders", "SELECT 990");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS SMALLINT), 0.023) FROM orders", "SELECT 990");
        this.assertQuery("SELECT approx_distinct(CAST((custkey % 128) AS TINYINT)) FROM orders", "SELECT 128");
        this.assertQuery("SELECT approx_distinct(CAST((custkey % 128) AS TINYINT), 0.023) FROM orders", "SELECT 128");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS DOUBLE)) FROM orders", "SELECT 1014");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS DOUBLE), 0.023) FROM orders", "SELECT 1014");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS VARCHAR)) FROM orders", "SELECT 1036");
        this.assertQuery("SELECT approx_distinct(CAST(custkey AS VARCHAR), 0.023) FROM orders", "SELECT 1036");
        this.assertQuery("SELECT approx_distinct(CAST(CAST(custkey AS VARCHAR) AS CHAR(20))) FROM orders", "SELECT 1036");
        this.assertQuery("SELECT approx_distinct(CAST(CAST(custkey AS VARCHAR) AS CHAR(20)), 0.023) FROM orders", "SELECT 1036");
        this.assertQuery("SELECT approx_distinct(to_utf8(CAST(custkey AS VARCHAR))) FROM orders", "SELECT 1036");
        this.assertQuery("SELECT approx_distinct(to_utf8(CAST(custkey AS VARCHAR)), 0.023) FROM orders", "SELECT 1036");
    }

    @Test
    public void testSumDataSizeForStats() {
        this.assertQuery("SELECT \"$internal$sum_data_size_for_stats\"(comment) FROM orders", "SELECT sum(length(comment)) FROM orders");
        this.assertQuery("SELECT \"$internal$sum_data_size_for_stats\"(CAST(comment AS CHAR(1000))) FROM orders", "SELECT 725468");
        this.assertQuery("SELECT \"$internal$sum_data_size_for_stats\"(CAST(comment AS VARBINARY)) FROM orders", "SELECT sum(length(comment)) FROM orders");
        this.assertQuery("SELECT \"$internal$sum_data_size_for_stats\"(ARRAY[comment]) FROM orders", "SELECT sum(length(comment)) FROM orders");
        this.assertQuery("SELECT \"$internal$sum_data_size_for_stats\"(ARRAY[comment, comment]) FROM orders", "SELECT 2 * sum(length(comment)) FROM orders");
        this.assertQuery("SELECT \"$internal$sum_data_size_for_stats\"(map(ARRAY[1], ARRAY[comment])) FROM orders", "SELECT 4 * count(*) + sum(length(comment)) FROM orders");
        this.assertQuery("SELECT \"$internal$sum_data_size_for_stats\"(map(ARRAY[1, 2], ARRAY[comment, comment])) FROM orders", "SELECT 2 * 4 * count(*) + 2 * sum(length(comment)) FROM orders");
        this.assertQuery("SELECT \"$internal$sum_data_size_for_stats\"(ROW(comment)) FROM orders", "SELECT sum(length(comment)) FROM orders");
        this.assertQuery("SELECT \"$internal$sum_data_size_for_stats\"(ROW(comment, comment)) FROM orders", "SELECT 2 * sum(length(comment)) FROM orders");
    }

    @Test
    public void testMaxDataSizeForStats() {
        this.assertQuery("SELECT \"$internal$max_data_size_for_stats\"(comment) FROM orders", "SELECT max(length(comment)) FROM orders");
        this.assertQuery("SELECT \"$internal$max_data_size_for_stats\"(CAST(comment AS CHAR(1000))) FROM orders", "SELECT max(length(comment)) FROM orders");
        this.assertQuery("SELECT \"$internal$max_data_size_for_stats\"(CAST(comment AS VARBINARY)) FROM orders", "SELECT max(length(comment)) FROM orders");
    }

    @Test
    public void testApproximateCountDistinctGroupBy() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, approx_distinct(custkey) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 990L}).row(new Object[]{"F", 990L}).row(new Object[]{"P", 303L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testApproximateCountDistinctGroupByWithStandardError() {
        MaterializedResult actual = this.computeActual("SELECT orderstatus, approx_distinct(custkey, 0.023) FROM orders GROUP BY orderstatus");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Iterable)actual.getTypes()).row(new Object[]{"O", 990L}).row(new Object[]{"F", 990L}).row(new Object[]{"P", 303L}).build();
        QueryAssertions.assertEqualsIgnoreOrder(actual.getMaterializedRows(), expected.getMaterializedRows());
    }

    @Test
    public void testDistinctNan() {
        MaterializedResult actual = this.computeActual("SELECT DISTINCT a/a FROM (VALUES (0.0e0), (0.0e0)) x (a)");
        Assert.assertTrue((boolean)Double.isNaN((Double)actual.getOnlyValue()));
    }

    @Test
    public void testGroupByNan() {
        MaterializedResult actual = this.computeActual("SELECT * FROM (VALUES nan(), nan(), nan()) GROUP BY 1");
        Assert.assertTrue((boolean)Double.isNaN((Double)actual.getOnlyValue()));
    }

    @Test
    public void testGroupByNanRow() {
        MaterializedResult actual = this.computeActual("SELECT a, b, c FROM (VALUES ROW(nan(), 1, 2), ROW(nan(), 1, 2)) t(a, b, c) GROUP BY 1, 2, 3");
        List actualRows = actual.getMaterializedRows();
        Assert.assertEquals((int)actualRows.size(), (int)1);
        Assert.assertTrue((boolean)Double.isNaN((Double)((MaterializedRow)actualRows.get(0)).getField(0)));
        Assert.assertEquals((Object)((MaterializedRow)actualRows.get(0)).getField(1), (Object)1);
        Assert.assertEquals((Object)((MaterializedRow)actualRows.get(0)).getField(2), (Object)2);
    }

    @Test
    public void testGroupByNanArray() {
        MaterializedResult actual = this.computeActual("SELECT a FROM (VALUES (ARRAY[nan(), 2e0, 3e0]), (ARRAY[nan(), 2e0, 3e0])) t(a) GROUP BY a");
        List actualRows = actual.getMaterializedRows();
        Assert.assertEquals((int)actualRows.size(), (int)1);
        List value = (List)((MaterializedRow)actualRows.get(0)).getField(0);
        Assert.assertTrue((boolean)Double.isNaN((Double)value.get(0)));
        Assert.assertEquals(value.get(1), (Object)2.0);
        Assert.assertEquals(value.get(2), (Object)3.0);
    }

    @Test
    public void testGroupByNanMap() {
        MaterializedResult actual = this.computeActual("SELECT MAP_KEYS(x)[1] FROM (VALUES MAP(ARRAY[nan()], ARRAY[ARRAY[1]]), MAP(ARRAY[nan()], ARRAY[ARRAY[2]])) t(x) GROUP BY 1");
        Assert.assertTrue((boolean)Double.isNaN((Double)actual.getOnlyValue()));
    }

    @Test
    public void testGroupByNoAggregations() {
        this.assertQuery("SELECT custkey FROM orders GROUP BY custkey");
    }

    @Test
    public void testGroupByCount() {
        this.assertQuery("SELECT orderstatus, COUNT(*) FROM orders GROUP BY orderstatus", "SELECT orderstatus, CAST(COUNT(*) AS INTEGER) FROM orders GROUP BY orderstatus");
    }

    @Test
    public void testGroupByMultipleFields() {
        this.assertQuery("SELECT custkey, orderstatus, COUNT(*) FROM orders GROUP BY custkey, orderstatus");
    }

    @Test
    public void testGroupByWithAlias() {
        this.assertQuery("SELECT orderdate x, COUNT(*) FROM orders GROUP BY orderdate", "SELECT orderdate x, CAST(COUNT(*) AS INTEGER) FROM orders GROUP BY orderdate");
    }

    @Test
    public void testGroupBySum() {
        this.assertQuery("SELECT suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY suppkey");
    }

    @Test
    public void testGroupByRequireIntegerCoercion() {
        this.assertQuery("SELECT partkey, COUNT(DISTINCT shipdate), SUM(linenumber) FROM lineitem GROUP BY partkey");
    }

    @Test
    public void testGroupByEmptyGroupingSet() {
        this.assertQuery("SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY ()", "SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupByWithWildcard() {
        this.assertQuery("SELECT * FROM (SELECT orderkey FROM orders) t GROUP BY orderkey");
    }

    @Test
    public void testSingleGroupingSet() {
        this.assertQuery("SELECT linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS (linenumber)", "SELECT linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber");
    }

    @Test
    public void testGroupingSets() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((linenumber, suppkey), (suppkey))", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION SELECT NULL, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY suppkey");
    }

    @Test
    public void testGroupingSetsNoInput() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY GROUPING SETS ((linenumber, suppkey), (suppkey))", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY linenumber, suppkey UNION SELECT NULL, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY suppkey");
    }

    @Test
    public void testGroupingSetsWithGlobalAggregationNoInput() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY GROUPING SETS ((linenumber, suppkey), (suppkey), ())", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY linenumber, suppkey UNION SELECT NULL, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY suppkey UNION SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0");
    }

    @Test
    public void testGroupingSetsWithSingleDistinct() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((linenumber, suppkey), (suppkey))", "SELECT linenumber, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION SELECT NULL, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)) FROM lineitem GROUP BY suppkey");
    }

    @Test
    public void testGroupingSetsWithMultipleDistinct() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)), COUNT(DISTINCT linestatus) FROM lineitem GROUP BY GROUPING SETS ((linenumber, suppkey), (suppkey))", "SELECT linenumber, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)), COUNT(DISTINCT linestatus) FROM lineitem GROUP BY linenumber, suppkey UNION SELECT NULL, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)), COUNT(DISTINCT linestatus) FROM lineitem GROUP BY suppkey");
    }

    @Test
    public void testGroupingSetsWithMultipleDistinctNoInput() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)), COUNT(DISTINCT linestatus) FROM lineitem WHERE quantity < 0 GROUP BY GROUPING SETS ((linenumber, suppkey), (suppkey))", "SELECT linenumber, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)), COUNT(DISTINCT linestatus) FROM lineitem WHERE quantity < 0 GROUP BY linenumber, suppkey UNION SELECT NULL, suppkey, SUM(DISTINCT CAST(quantity AS BIGINT)), COUNT(DISTINCT linestatus) FROM lineitem WHERE quantity < 0 GROUP BY suppkey");
    }

    @Test
    public void testGroupingSetsGrandTotalSet() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((linenumber, suppkey), ())", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsRepeatedSetsAll() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((), (linenumber, suppkey), (), (linenumber, suppkey))", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem UNION ALL SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsRepeatedSetsAllNoInput() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY GROUPING SETS ((), (linenumber, suppkey), (), (linenumber, suppkey))", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY linenumber, suppkey UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 UNION ALL SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY linenumber, suppkey UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0");
    }

    @Test
    public void testGroupingSetsRepeatedSetsDistinct() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY DISTINCT GROUPING SETS ((), (linenumber, suppkey), (), (linenumber, suppkey))", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsGrandTotalSetFirst() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((), (linenumber), (linenumber, suppkey))", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION ALL SELECT linenumber, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsOnlyGrandTotalSet() {
        this.assertQuery("SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS (())", "SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsMultipleGrandTotalSets() {
        this.assertQuery("SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((), ())", "SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem UNION ALL SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsMultipleGrandTotalSetsNoInput() {
        this.assertQuery("SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY GROUPING SETS ((), ())", "SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 UNION ALL SELECT SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0");
    }

    @Test
    public void testGroupingSetsAliasedGroupingColumns() {
        this.assertQuery("SELECT lna, lnb, SUM(quantity) FROM (SELECT linenumber lna, linenumber lnb, CAST(quantity AS BIGINT) quantity FROM lineitem) GROUP BY GROUPING SETS ((lna, lnb), (lna), (lnb), ())", "SELECT linenumber, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber UNION ALL SELECT linenumber, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber UNION ALL SELECT NULL, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetMixedExpressionAndColumn() {
        this.assertQuery("SELECT suppkey, month(shipdate), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY month(shipdate), ROLLUP(suppkey)", "SELECT suppkey, month(shipdate), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY month(shipdate), suppkey UNION ALL SELECT NULL, month(shipdate), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY month(shipdate)");
    }

    @Test
    public void testGroupingSetMixedExpressionAndOrdinal() {
        this.assertQuery("SELECT suppkey, month(shipdate), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY 2, ROLLUP(suppkey)", "SELECT suppkey, month(shipdate), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY month(shipdate), suppkey UNION ALL SELECT NULL, month(shipdate), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY month(shipdate)");
    }

    @Test
    public void testGroupingSetSubsetAndPartitioning() {
        this.assertQuery("SELECT COUNT_IF(x IS NULL) FROM (SELECT x, y, COUNT(z) FROM (SELECT CAST(lineitem.orderkey AS BIGINT) x, lineitem.linestatus y, SUM(lineitem.quantity) z FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey GROUP BY 1, 2) GROUP BY GROUPING SETS ((x, y), ()))", "SELECT 1");
    }

    @Test
    public void testGroupingSetPredicatePushdown() {
        this.assertQuery("SELECT * FROM (SELECT COALESCE(orderpriority, 'ALL'), COALESCE(shippriority, -1) sp FROM (SELECT orderpriority, shippriority, COUNT(1) FROM orders GROUP BY GROUPING SETS ((orderpriority), (shippriority)))) WHERE sp=-1", "SELECT orderpriority, -1 FROM orders GROUP BY orderpriority");
    }

    @Test
    public void testGroupingSetsAggregateOnGroupedColumn() {
        this.assertQuery("SELECT orderpriority, COUNT(orderpriority) FROM orders GROUP BY ROLLUP (orderpriority)", "SELECT orderpriority, COUNT(orderpriority) FROM orders GROUP BY orderpriority UNION SELECT NULL, COUNT(orderpriority) FROM orders");
    }

    @Test
    public void testGroupingSetsMultipleAggregatesOnGroupedColumn() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(suppkey), COUNT(linenumber), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((linenumber, suppkey), ())", "SELECT linenumber, suppkey, SUM(suppkey), COUNT(linenumber), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION SELECT NULL, NULL, SUM(suppkey), COUNT(linenumber), SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsMultipleAggregatesOnUngroupedColumn() {
        this.assertQuery("SELECT linenumber, suppkey, COUNT(CAST(quantity AS BIGINT)), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((linenumber, suppkey), ())", "SELECT linenumber, suppkey, COUNT(CAST(quantity AS BIGINT)), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION SELECT NULL, NULL, COUNT(CAST(quantity AS BIGINT)), SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsMultipleAggregatesWithGroupedColumns() {
        this.assertQuery("SELECT linenumber, suppkey, COUNT(linenumber), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY GROUPING SETS ((linenumber, suppkey), ())", "SELECT linenumber, suppkey, COUNT(linenumber), SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION SELECT NULL, NULL, COUNT(linenumber), SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testGroupingSetsWithSingleDistinctAndUnion() {
        this.assertQuery("SELECT suppkey, COUNT(DISTINCT linenumber) FROM (SELECT * FROM lineitem WHERE linenumber%2 = 0 UNION ALL SELECT * FROM lineitem WHERE linenumber%2 = 1) GROUP BY GROUPING SETS ((suppkey), ())", "SELECT suppkey, COUNT(DISTINCT linenumber) FROM lineitem GROUP BY suppkey UNION ALL SELECT NULL, COUNT(DISTINCT linenumber) FROM lineitem");
    }

    @Test
    public void testGroupingSetsWithSingleDistinctAndUnionGroupedArguments() {
        this.assertQuery("SELECT linenumber, COUNT(DISTINCT linenumber) FROM (SELECT * FROM lineitem WHERE linenumber%2 = 0 UNION ALL SELECT * FROM lineitem WHERE linenumber%2 = 1) GROUP BY GROUPING SETS ((linenumber), ())", "SELECT DISTINCT linenumber, 1 FROM lineitem UNION ALL SELECT NULL, COUNT(DISTINCT linenumber) FROM lineitem");
    }

    @Test
    public void testGroupingSetsWithMultipleDistinctAndUnion() {
        this.assertQuery("SELECT linenumber, COUNT(DISTINCT linenumber), SUM(DISTINCT suppkey) FROM (SELECT * FROM lineitem WHERE linenumber%2 = 0 UNION ALL SELECT * FROM lineitem WHERE linenumber%2 = 1) GROUP BY GROUPING SETS ((linenumber), ())", "SELECT linenumber, 1, SUM(DISTINCT suppkey) FROM lineitem GROUP BY linenumber UNION ALL SELECT NULL, COUNT(DISTINCT linenumber), SUM(DISTINCT suppkey) FROM lineitem");
    }

    @Test
    public void testRollup() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY ROLLUP (linenumber, suppkey)", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION ALL SELECT linenumber, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testCube() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY CUBE (linenumber, suppkey)", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber, suppkey UNION ALL SELECT linenumber, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY linenumber UNION ALL SELECT NULL, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY suppkey UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem");
    }

    @Test
    public void testCubeNoInput() {
        this.assertQuery("SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY CUBE (linenumber, suppkey)", "SELECT linenumber, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY linenumber, suppkey UNION ALL SELECT linenumber, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY linenumber UNION ALL SELECT NULL, suppkey, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0 GROUP BY suppkey UNION ALL SELECT NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem WHERE quantity < 0");
    }

    @Test
    public void testGroupingCombinationsAll() {
        this.assertQuery("SELECT orderkey, partkey, suppkey, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey, ROLLUP (suppkey, linenumber), CUBE (linenumber)", "SELECT orderkey, partkey, suppkey, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, suppkey, linenumber UNION ALL SELECT orderkey, partkey, suppkey, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey, suppkey, linenumber UNION ALL SELECT orderkey, partkey, NULL, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey, linenumber UNION ALL SELECT orderkey, partkey, suppkey, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey, suppkey, linenumber UNION ALL SELECT orderkey, partkey, suppkey, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey, suppkey UNION ALL SELECT orderkey, partkey, NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey");
    }

    @Test
    public void testGroupingCombinationsDistinct() {
        this.assertQuery("SELECT orderkey, partkey, suppkey, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY DISTINCT orderkey, partkey, ROLLUP (suppkey, linenumber), CUBE (linenumber)", "SELECT orderkey, partkey, suppkey, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, suppkey, linenumber UNION ALL SELECT orderkey, partkey, NULL, linenumber, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey, linenumber UNION ALL SELECT orderkey, partkey, suppkey, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey, suppkey UNION ALL SELECT orderkey, partkey, NULL, NULL, SUM(CAST(quantity AS BIGINT)) FROM lineitem GROUP BY orderkey, partkey");
    }

    @Test
    public void testOrderedAggregations() {
        this.assertQuery("SELECT orderpriority, custkey, array_agg(orderstatus ORDER BY orderstatus) FILTER (WHERE custkey > 500)FROM orders WHERE orderkey IN (1, 2, 3, 4, 5) GROUP BY GROUPING SETS ((), (orderpriority), (orderpriority, custkey))", "VALUES (NULL, NULL , ('F', 'O', 'O')),('5-LOW', NULL , ('F', 'O')),('1-URGENT', NULL , ('O')),('5-LOW', 370 , NULL),('5-LOW', 1234, ('F')),('5-LOW', 1369, ('O')),('5-LOW', 445 , NULL),('1-URGENT', 781 , ('O'))");
    }

    @Test
    public void testAggregationWithConstantArgumentsOverScalar() {
        this.assertQuery("SELECT count(1) FROM (SELECT count(custkey) FROM orders LIMIT 10) a");
    }

    @Test
    public void testGroupingSetsWithDefaultValue() {
        this.assertQuery("SELECT orderkey, COUNT(DISTINCT k) FROM (SELECT orderkey, 1 k FROM orders) GROUP BY GROUPING SETS ((), orderkey) HAVING orderkey IS NULL", "VALUES (null, 1)");
    }

    @Test
    public void testApproxMostFrequentWithLong() {
        MaterializedResult actual1 = this.computeActual("SELECT approx_most_frequent(3, cast(x as bigint), 15) FROM (values 1, 2, 1, 3, 1, 2, 3, 4, 5) t(x)");
        Assert.assertEquals((int)actual1.getRowCount(), (int)1);
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(0)).getFields().get(0), (Object)ImmutableMap.of((Object)1L, (Object)3L, (Object)2L, (Object)2L, (Object)3L, (Object)2L));
        MaterializedResult actual2 = this.computeActual("SELECT approx_most_frequent(2, cast(x as bigint), 15) FROM (values 1, 2, 1, 3, 1, 2, 3, 4, 5) t(x)");
        Assert.assertEquals((int)actual2.getRowCount(), (int)1);
        Assert.assertEquals(((MaterializedRow)actual2.getMaterializedRows().get(0)).getFields().get(0), (Object)ImmutableMap.of((Object)1L, (Object)3L, (Object)2L, (Object)2L));
    }

    @Test
    public void testApproxMostFrequentWithVarchar() {
        MaterializedResult actual1 = this.computeActual("SELECT approx_most_frequent(3, x, 15) FROM (values 'A', 'B', 'A', 'C', 'A', 'B', 'C', 'D', 'E') t(x)");
        Assert.assertEquals((int)actual1.getRowCount(), (int)1);
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(0)).getFields().get(0), (Object)ImmutableMap.of((Object)"A", (Object)3L, (Object)"B", (Object)2L, (Object)"C", (Object)2L));
        MaterializedResult actual2 = this.computeActual("SELECT approx_most_frequent(2, x, 15) FROM (values 'A', 'B', 'A', 'C', 'A', 'B', 'C', 'D', 'E') t(x)");
        Assert.assertEquals((int)actual2.getRowCount(), (int)1);
        Assert.assertEquals(((MaterializedRow)actual2.getMaterializedRows().get(0)).getFields().get(0), (Object)ImmutableMap.of((Object)"A", (Object)3L, (Object)"B", (Object)2L));
    }

    @Test
    public void testApproxMostFrequentWithLongGroupBy() {
        MaterializedResult actual1 = this.computeActual("SELECT k, approx_most_frequent(3, cast(v as bigint), 15) FROM (values ('a', 1), ('b', 2), ('a', 1), ('c', 3), ('a', 1), ('b', 2), ('c', 3), ('a', 4), ('b', 5)) t(k, v) GROUP BY 1 ORDER BY 1");
        Assert.assertEquals((int)actual1.getRowCount(), (int)3);
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(0)).getFields().get(0), (Object)"a");
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(0)).getFields().get(1), (Object)ImmutableMap.of((Object)1L, (Object)3L, (Object)4L, (Object)1L));
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(1)).getFields().get(0), (Object)"b");
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(1)).getFields().get(1), (Object)ImmutableMap.of((Object)2L, (Object)2L, (Object)5L, (Object)1L));
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(2)).getFields().get(0), (Object)"c");
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(2)).getFields().get(1), (Object)ImmutableMap.of((Object)3L, (Object)2L));
    }

    @Test
    public void testApproxMostFrequentWithStringGroupBy() {
        MaterializedResult actual1 = this.computeActual("SELECT k, approx_most_frequent(3, v, 15) FROM (values ('a', 'A'), ('b', 'B'), ('a', 'A'), ('c', 'C'), ('a', 'A'), ('b', 'B'), ('c', 'C'), ('a', 'D'), ('b', 'E')) t(k, v) GROUP BY 1 ORDER BY 1");
        Assert.assertEquals((int)actual1.getRowCount(), (int)3);
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(0)).getFields().get(0), (Object)"a");
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(0)).getFields().get(1), (Object)ImmutableMap.of((Object)"A", (Object)3L, (Object)"D", (Object)1L));
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(1)).getFields().get(0), (Object)"b");
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(1)).getFields().get(1), (Object)ImmutableMap.of((Object)"B", (Object)2L, (Object)"E", (Object)1L));
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(2)).getFields().get(0), (Object)"c");
        Assert.assertEquals(((MaterializedRow)actual1.getMaterializedRows().get(2)).getFields().get(1), (Object)ImmutableMap.of((Object)"C", (Object)2L));
    }
}

