/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testng.services;

import com.google.common.base.Joiner;
import com.google.errorprone.annotations.FormatMethod;
import org.testng.ITestClass;
import org.testng.ITestNGListener;
import org.testng.ITestResult;

final class Listeners {
    private Listeners() {
    }

    @FormatMethod
    public static void reportListenerFailure(Class<? extends ITestNGListener> listenerClass, String format, Object ... args) {
        System.err.println(String.format("FATAL: %s: ", listenerClass.getName()) + String.format(format, args));
        System.err.println("JVM will be terminated");
        System.exit(1);
    }

    public static String formatTestName(ITestClass testClass) {
        return testClass.getName();
    }

    public static String formatTestName(ITestResult testCase) {
        return String.format("%s.%s%s", testCase.getTestClass().getName(), testCase.getName(), Listeners.formatTestParameters(testCase));
    }

    private static String formatTestParameters(ITestResult testCase) {
        Object[] parameters = testCase.getParameters();
        if (parameters == null || parameters.length == 0) {
            return "";
        }
        return String.format(" [%s]", Joiner.on((String)", ").useForNull("null").join(parameters));
    }
}

