/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testng.services;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.trino.testng.services.Listeners;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.testng.IClassListener;
import org.testng.ITestClass;
import org.testng.annotations.Test;

public class ReportUnannotatedMethods
implements IClassListener {
    public void onBeforeClass(ITestClass testClass) {
        try {
            this.reportUnannotatedTestMethods(testClass);
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(ReportUnannotatedMethods.class, "Failed to process %s: \n%s", testClass, Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void reportUnannotatedTestMethods(ITestClass testClass) {
        Class realClass = testClass.getRealClass();
        if (realClass.getSuperclass() != null && "io.trino.tempto.internal.convention.ConventionBasedTestProxyGenerator$ConventionBasedTestProxy".equals(realClass.getSuperclass().getName())) {
            return;
        }
        List<Method> unannotatedTestMethods = ReportUnannotatedMethods.findUnannotatedTestMethods(realClass);
        if (!unannotatedTestMethods.isEmpty()) {
            Listeners.reportListenerFailure(ReportUnannotatedMethods.class, "Test class %s has methods which are public but not explicitly annotated. Are they missing @Test?%s", realClass.getName(), unannotatedTestMethods.stream().map(Method::toString).collect(Collectors.joining("\n\t\t", "\n\t\t", "")));
        }
    }

    @VisibleForTesting
    static List<Method> findUnannotatedTestMethods(Class<?> realClass) {
        return (List)Arrays.stream(realClass.getMethods()).filter(method -> method.getDeclaringClass() != Object.class).filter(method -> !Modifier.isStatic(method.getModifiers())).filter(method -> !method.isBridge()).filter(method -> !ReportUnannotatedMethods.isAllowedPublicMethodInTest(method)).collect(ImmutableList.toImmutableList());
    }

    public void onAfterClass(ITestClass testClass) {
    }

    private static boolean isAllowedPublicMethodInTest(Method method) {
        if (ReportUnannotatedMethods.isTestAnnotated(method)) {
            return true;
        }
        if (method.getDeclaringClass() == Object.class) {
            return true;
        }
        if (method.getDeclaringClass().isInterface()) {
            return ReportUnannotatedMethods.isTemptoClass(method.getDeclaringClass());
        }
        for (Class<?> interfaceClass : method.getDeclaringClass().getInterfaces()) {
            Optional<Method> overridden = ReportUnannotatedMethods.getOverridden(method, interfaceClass);
            if (!overridden.isPresent() || !ReportUnannotatedMethods.isTemptoClass(interfaceClass)) continue;
            return true;
        }
        return ReportUnannotatedMethods.getOverridden(method, method.getDeclaringClass().getSuperclass()).map(ReportUnannotatedMethods::isAllowedPublicMethodInTest).orElse(false);
    }

    private static Optional<Method> getOverridden(Method method, Class<?> base) {
        try {
            return Optional.of(base.getMethod(method.getName(), method.getParameterTypes()));
        }
        catch (NoSuchMethodException ignored) {
            return Optional.empty();
        }
    }

    private static boolean isTestAnnotated(Method method) {
        return Arrays.stream(method.getAnnotations()).map(Annotation::annotationType).anyMatch(annotationClass -> {
            if (Suppress.class.equals(annotationClass)) {
                return true;
            }
            if ("org.openjdk.jmh.annotations.Benchmark".equals(annotationClass.getName())) {
                return true;
            }
            if (Test.class.getPackage().equals(annotationClass.getPackage())) {
                return true;
            }
            return ReportUnannotatedMethods.isTemptoClass(annotationClass);
        });
    }

    @VisibleForTesting
    static boolean isTemptoClass(Class<?> aClass) {
        String temptoPackage = "io.trino.tempto";
        String aPackage = aClass.getPackage().getName();
        return aPackage.equals(temptoPackage) || aPackage.startsWith(temptoPackage + ".");
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Suppress {
    }
}

