/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.kafka;

import io.airlift.log.Logger;
import java.io.PrintStream;
import java.util.Objects;
import org.testcontainers.containers.output.BaseConsumer;
import org.testcontainers.containers.output.OutputFrame;

public final class PrintingLogConsumer
extends BaseConsumer<PrintingLogConsumer> {
    private static final Logger log = Logger.get(PrintingLogConsumer.class);
    private final PrintStream out;
    private final String prefix;

    public PrintingLogConsumer(PrintStream out, String prefix) {
        this.out = Objects.requireNonNull(out, "out is null");
        this.prefix = Objects.requireNonNull(prefix, "prefix is null");
    }

    public void accept(OutputFrame outputFrame) {
        String message = outputFrame.getUtf8String().replaceAll("\\r?\\n?$", "");
        if (message.contains("\n")) {
            log.warn("Message contains newline character: [%s]", new Object[]{message});
        }
        if (!message.isEmpty() || outputFrame.getType() != OutputFrame.OutputType.END) {
            this.out.println(this.prefix + message);
        }
        if (outputFrame.getType() == OutputFrame.OutputType.END) {
            this.out.println(this.prefix + "(exited)");
        }
        this.out.flush();
    }
}

