/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.sqlserver;

import com.google.common.base.CharMatcher;
import io.airlift.slice.Slice;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.spi.expression.Constant;
import io.trino.spi.type.VarcharType;
import java.util.Optional;

public class RewriteUnicodeVarcharConstant
implements ConnectorExpressionRule<Constant, String> {
    private static final Pattern<Constant> PATTERN = ConnectorExpressionPatterns.constant().with(ConnectorExpressionPatterns.type().matching(VarcharType.class::isInstance));
    private static final CharMatcher UNICODE_CHARACTER_MATCHER = CharMatcher.ascii().negate().precomputed();

    public Pattern<Constant> getPattern() {
        return PATTERN;
    }

    public Optional<String> rewrite(Constant constant, Captures captures, ConnectorExpressionRule.RewriteContext<String> context) {
        if (constant.getValue() == null) {
            return Optional.empty();
        }
        Slice slice = (Slice)constant.getValue();
        if (slice == null) {
            return Optional.empty();
        }
        String sliceUtf8String = slice.toStringUtf8();
        boolean isUnicodeString = UNICODE_CHARACTER_MATCHER.matchesAnyOf((CharSequence)sliceUtf8String);
        if (isUnicodeString) {
            return Optional.of("N'" + sliceUtf8String.replace("'", "''") + "'");
        }
        return Optional.of("'" + sliceUtf8String.replace("'", "''") + "'");
    }
}

