/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spooling.filesystem.encryption;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class HeadersUtils {
    private HeadersUtils() {
    }

    public static String getOnlyHeader(Map<String, List<String>> headers, String name) {
        String headerName = HeadersUtils.normalizeHeaderNameCase(name);
        List<String> values = headers.get(headerName);
        Preconditions.checkArgument((values != null && !values.isEmpty() ? 1 : 0) != 0, (String)"Required header %s was not found", (Object)headerName);
        Preconditions.checkArgument((values.size() == 1 ? 1 : 0) != 0, (String)"Required header %s contains more than one value", (Object)headerName);
        return values.getFirst();
    }

    static Map<String, List<String>> normalizeHeaders(Map<String, List<String>> headers) {
        return (Map)headers.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> HeadersUtils.normalizeHeaderNameCase((String)entry.getKey()), entry -> List.copyOf((Collection)entry.getValue())));
    }

    static String normalizeHeaderNameCase(String headerName) {
        return headerName.toLowerCase(Locale.ENGLISH);
    }
}

