/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spooling.filesystem;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.MapBinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.azure.AzureFileSystemFactory;
import io.trino.filesystem.azure.AzureFileSystemModule;
import io.trino.filesystem.gcs.GcsFileSystemFactory;
import io.trino.filesystem.gcs.GcsFileSystemModule;
import io.trino.filesystem.s3.S3FileSystemFactory;
import io.trino.filesystem.s3.S3FileSystemModule;
import io.trino.filesystem.switching.SwitchingFileSystemFactory;
import io.trino.filesystem.tracing.TracingFileSystemFactory;
import io.trino.plugin.base.ClosingBinder;
import io.trino.spi.protocol.SpoolingManager;
import io.trino.spi.protocol.SpoolingManagerContext;
import io.trino.spooling.filesystem.FileSystemSegmentPruner;
import io.trino.spooling.filesystem.FileSystemSpoolingConfig;
import io.trino.spooling.filesystem.FileSystemSpoolingManager;
import io.trino.spooling.filesystem.ForSegmentPruner;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public class FileSystemSpoolingModule
extends AbstractConfigurationAwareModule {
    private final boolean coordinator;

    public FileSystemSpoolingModule(boolean coordinator) {
        this.coordinator = coordinator;
    }

    protected void setup(Binder binder) {
        FileSystemSpoolingConfig config = (FileSystemSpoolingConfig)this.buildConfigObject(FileSystemSpoolingConfig.class);
        MapBinder factories = MapBinder.newMapBinder((Binder)binder, String.class, TrinoFileSystemFactory.class);
        if (config.isAzureEnabled()) {
            this.install((Module)new AzureFileSystemModule());
            factories.addBinding((Object)"abfs").to(AzureFileSystemFactory.class);
        }
        if (config.isS3Enabled()) {
            this.install((Module)new S3FileSystemModule());
            factories.addBinding((Object)"s3").to(S3FileSystemFactory.class);
        }
        if (config.isGcsEnabled()) {
            this.install((Module)new GcsFileSystemModule());
            factories.addBinding((Object)"gs").to(GcsFileSystemFactory.class);
        }
        binder.bind(SpoolingManager.class).to(FileSystemSpoolingManager.class).in(Scopes.SINGLETON);
        if (this.coordinator) {
            binder.bind(FileSystemSegmentPruner.class).asEagerSingleton();
            binder.bind(ScheduledExecutorService.class).annotatedWith(ForSegmentPruner.class).toInstance((Object)Executors.newScheduledThreadPool(1, Threads.threadsNamed((String)"segment-pruner-%d")));
            ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ScheduledExecutorService.class, ForSegmentPruner.class));
        }
    }

    @Provides
    @Singleton
    public TrinoFileSystemFactory createFileSystemFactory(Map<String, TrinoFileSystemFactory> factories, SpoolingManagerContext context) {
        Function<Location, TrinoFileSystemFactory> loader = location -> location.scheme().map(factories::get).orElseThrow(() -> new IllegalArgumentException("No factory for location: " + String.valueOf(location)));
        return new TracingFileSystemFactory(context.getTracer(), (TrinoFileSystemFactory)new SwitchingFileSystemFactory(loader));
    }
}

