/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.Plugin;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.sonatype.aether.artifact.Artifact;

final class PluginDiscovery {
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final String SERVICES_FILE = "META-INF/services/" + Plugin.class.getName();

    private PluginDiscovery() {
    }

    public static Set<String> discoverPlugins(Artifact artifact, ClassLoader classLoader) throws IOException {
        if (!artifact.getExtension().equals("trino-plugin")) {
            throw new RuntimeException("Unexpected extension for main artifact: " + String.valueOf(artifact));
        }
        File file = artifact.getFile();
        if (!file.getPath().endsWith("/target/classes")) {
            throw new RuntimeException("Unexpected file for main artifact: " + String.valueOf(file));
        }
        if (!file.exists()) {
            throw new RuntimeException("Main artifact directory does not exist: " + String.valueOf(file));
        }
        if (!file.isDirectory()) {
            throw new RuntimeException("Main artifact location is not a directory: " + String.valueOf(file));
        }
        if (new File(file, SERVICES_FILE).exists()) {
            throw new RuntimeException("Unexpected services file in artifact directory: " + String.valueOf(file));
        }
        return (Set)PluginDiscovery.listClasses(file.toPath()).stream().filter(name -> PluginDiscovery.classInterfaces(name, classLoader).contains(Plugin.class.getName())).collect(ImmutableSet.toImmutableSet());
    }

    public static void writePluginServices(Iterable<String> plugins, File root) throws IOException {
        Path path = root.toPath().resolve(SERVICES_FILE);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(path.toFile()), StandardCharsets.UTF_8);){
            for (String plugin : plugins) {
                out.write(plugin + "\n");
            }
        }
    }

    private static List<String> listClasses(final Path base) throws IOException {
        final ImmutableList.Builder list = ImmutableList.builder();
        Files.walkFileTree(base, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                if (file.getFileName().toString().endsWith(PluginDiscovery.CLASS_FILE_SUFFIX)) {
                    String name = file.subpath(base.getNameCount(), file.getNameCount()).toString();
                    list.add((Object)PluginDiscovery.javaName(name.substring(0, name.length() - PluginDiscovery.CLASS_FILE_SUFFIX.length())));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return list.build();
    }

    private static List<String> classInterfaces(String name, ClassLoader classLoader) {
        ImmutableList.Builder list = ImmutableList.builder();
        ClassReader reader = PluginDiscovery.readClass(name, classLoader);
        for (String binaryName : reader.getInterfaces()) {
            list.add((Object)PluginDiscovery.javaName(binaryName));
        }
        if (reader.getSuperName() != null) {
            list.addAll(PluginDiscovery.classInterfaces(PluginDiscovery.javaName(reader.getSuperName()), classLoader));
        }
        return list.build();
    }

    private static ClassReader readClass(String name, ClassLoader classLoader) {
        ClassReader classReader;
        block9: {
            InputStream in = classLoader.getResourceAsStream(PluginDiscovery.binaryName(name) + CLASS_FILE_SUFFIX);
            try {
                if (in == null) {
                    throw new RuntimeException("Failed to read class: " + name);
                }
                classReader = new ClassReader(in.readAllBytes());
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return classReader;
    }

    private static String binaryName(String javaName) {
        return javaName.replace('.', '/');
    }

    private static String javaName(String binaryName) {
        return binaryName.replace('/', '.');
    }
}

