/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.resourcegroups.db;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.base.jmx.PrefixObjectNameGeneratorModule;
import io.trino.plugin.resourcegroups.db.DbResourceGroupConfig;
import io.trino.plugin.resourcegroups.db.DbResourceGroupConfigurationManager;
import io.trino.plugin.resourcegroups.db.DbResourceGroupsModule;
import io.trino.plugin.resourcegroups.db.FlywayMigration;
import io.trino.plugin.resourcegroups.db.ForEnvironment;
import io.trino.spi.memory.ClusterMemoryPoolManager;
import io.trino.spi.resourcegroups.ResourceGroupConfigurationManager;
import io.trino.spi.resourcegroups.ResourceGroupConfigurationManagerContext;
import io.trino.spi.resourcegroups.ResourceGroupConfigurationManagerFactory;
import java.util.Map;
import org.weakref.jmx.guice.MBeanModule;

public class DbResourceGroupConfigurationManagerFactory
implements ResourceGroupConfigurationManagerFactory {
    public String getName() {
        return "db";
    }

    public ResourceGroupConfigurationManager<?> create(Map<String, String> config, ResourceGroupConfigurationManagerContext context) {
        FlywayMigration.migrate((DbResourceGroupConfig)new ConfigurationFactory(config).build(DbResourceGroupConfig.class));
        Bootstrap app = new Bootstrap(new Module[]{new MBeanModule(), new MBeanServerModule(), new JsonModule(), new DbResourceGroupsModule(), new PrefixObjectNameGeneratorModule("io.trino.plugin.resourcegroups.db", "trino.plugin.resourcegroups.db"), binder -> binder.bind(String.class).annotatedWith(ForEnvironment.class).toInstance((Object)context.getEnvironment()), binder -> binder.bind(ClusterMemoryPoolManager.class).toInstance((Object)context.getMemoryPoolManager())});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (ResourceGroupConfigurationManager)injector.getInstance(DbResourceGroupConfigurationManager.class);
    }
}

