/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.avro;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.RowDecoder;
import io.trino.decoder.RowDecoderFactory;
import io.trino.decoder.RowDecoderSpec;
import io.trino.decoder.avro.AvroDeserializer;
import io.trino.decoder.avro.AvroReaderSupplier;
import io.trino.decoder.avro.GenericRecordRowDecoder;
import io.trino.decoder.avro.SingleValueRowDecoder;
import io.trino.decoder.dummy.DummyRowDecoderFactory;
import io.trino.spi.connector.ConnectorSession;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class AvroRowDecoderFactory
implements RowDecoderFactory {
    public static final String NAME = "avro";
    public static final String DATA_SCHEMA = "dataSchema";
    private final AvroReaderSupplier.Factory avroReaderSupplierFactory;
    private final AvroDeserializer.Factory avroDeserializerFactory;

    @Inject
    public AvroRowDecoderFactory(AvroReaderSupplier.Factory avroReaderSupplierFactory, AvroDeserializer.Factory avroDeserializerFactory) {
        this.avroReaderSupplierFactory = Objects.requireNonNull(avroReaderSupplierFactory, "avroReaderSupplierFactory is null");
        this.avroDeserializerFactory = Objects.requireNonNull(avroDeserializerFactory, "avroDeserializerFactory is null");
    }

    @Override
    public RowDecoder create(ConnectorSession session, RowDecoderSpec rowDecoderSpec) {
        if (rowDecoderSpec.columns().isEmpty()) {
            return DummyRowDecoderFactory.DECODER_INSTANCE;
        }
        String dataSchema = Objects.requireNonNull(rowDecoderSpec.decoderParams().get(DATA_SCHEMA), String.format("%s cannot be null", DATA_SCHEMA));
        Schema parsedSchema = new Schema.Parser().parse(dataSchema);
        if (parsedSchema.getType().equals((Object)Schema.Type.RECORD)) {
            AvroReaderSupplier avroReaderSupplier = this.avroReaderSupplierFactory.create(parsedSchema);
            AvroDeserializer<GenericRecord> dataDecoder = this.avroDeserializerFactory.create(avroReaderSupplier);
            return new GenericRecordRowDecoder(dataDecoder, rowDecoderSpec.columns());
        }
        AvroReaderSupplier avroReaderSupplier = this.avroReaderSupplierFactory.create(parsedSchema);
        AvroDeserializer<Object> dataDecoder = this.avroDeserializerFactory.create(avroReaderSupplier);
        return new SingleValueRowDecoder(dataDecoder, (DecoderColumnHandle)Iterables.getOnlyElement(rowDecoderSpec.columns()));
    }
}

