/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.protobuf;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.protobuf.Descriptors;
import io.trino.cache.SafeCaches;
import io.trino.decoder.protobuf.DescriptorProvider;
import io.trino.decoder.protobuf.ProtobufErrorCode;
import io.trino.decoder.protobuf.ProtobufUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public class FileDescriptorProvider
implements DescriptorProvider {
    private final LoadingCache<String, Descriptors.Descriptor> protobufTypeUrlCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L), (CacheLoader)CacheLoader.from(this::loadDescriptorFromType));

    @Override
    public Optional<Descriptors.Descriptor> getDescriptorFromTypeUrl(String url) {
        try {
            Objects.requireNonNull(url, "url is null");
            return Optional.of((Descriptors.Descriptor)this.protobufTypeUrlCache.get((Object)url));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private Descriptors.Descriptor loadDescriptorFromType(String url) {
        try {
            Descriptors.Descriptor descriptor = ProtobufUtils.getFileDescriptor(this.getContents(url)).findMessageTypeByName("schema");
            Preconditions.checkState((descriptor != null ? 1 : 0) != 0, (Object)String.format("Message %s not found", "schema"));
            return descriptor;
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new TrinoException((ErrorCodeSupplier)ProtobufErrorCode.INVALID_PROTO_FILE, "Unable to parse protobuf schema", (Throwable)e);
        }
    }
}

