/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.avro;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.DecoderErrorCode;
import io.trino.decoder.FieldValueProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.MapValueBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;

public class AvroColumnDecoder {
    private static final Set<Type> SUPPORTED_PRIMITIVE_TYPES = ImmutableSet.of((Object)BooleanType.BOOLEAN, (Object)TinyintType.TINYINT, (Object)SmallintType.SMALLINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)RealType.REAL, (Object[])new Type[]{DoubleType.DOUBLE, VarbinaryType.VARBINARY});
    private final Type columnType;
    private final String columnMapping;
    private final String columnName;

    public AvroColumnDecoder(DecoderColumnHandle columnHandle) {
        try {
            Objects.requireNonNull(columnHandle, "columnHandle is null");
            this.columnType = columnHandle.getType();
            this.columnMapping = columnHandle.getMapping();
            this.columnName = columnHandle.getName();
            Preconditions.checkArgument((!columnHandle.isInternal() ? 1 : 0) != 0, (String)"unexpected internal column '%s'", (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getFormatHint() == null ? 1 : 0) != 0, (String)"unexpected format hint '%s' defined for column '%s'", (Object)columnHandle.getFormatHint(), (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getDataFormat() == null ? 1 : 0) != 0, (String)"unexpected data format '%s' defined for column '%s'", (Object)columnHandle.getDataFormat(), (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getMapping() != null ? 1 : 0) != 0, (String)"mapping not defined for column '%s'", (Object)this.columnName);
            Preconditions.checkArgument((boolean)this.isSupportedType(this.columnType), (String)"Unsupported column type '%s' for column '%s'", (Object)this.columnType, (Object)this.columnName);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (Throwable)e);
        }
    }

    private boolean isSupportedType(Type type) {
        if (this.isSupportedPrimitive(type)) {
            return true;
        }
        if (type instanceof ArrayType) {
            Preconditions.checkArgument((type.getTypeParameters().size() == 1 ? 1 : 0) != 0, (Object)"expecting exactly one type parameter for array");
            return this.isSupportedType((Type)type.getTypeParameters().get(0));
        }
        if (type instanceof MapType) {
            List typeParameters = type.getTypeParameters();
            Preconditions.checkArgument((typeParameters.size() == 2 ? 1 : 0) != 0, (Object)"expecting exactly two type parameters for map");
            Preconditions.checkArgument((boolean)(typeParameters.get(0) instanceof VarcharType), (String)"Unsupported column type '%s' for map key", typeParameters.get(0));
            return this.isSupportedType((Type)type.getTypeParameters().get(1));
        }
        if (type instanceof RowType) {
            for (Type fieldType : type.getTypeParameters()) {
                if (this.isSupportedType(fieldType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isSupportedPrimitive(Type type) {
        return type instanceof VarcharType || SUPPORTED_PRIMITIVE_TYPES.contains(type);
    }

    public FieldValueProvider decodeField(GenericRecord avroRecord) {
        Object avroColumnValue;
        try {
            avroColumnValue = AvroColumnDecoder.locateNode(avroRecord, this.columnMapping);
        }
        catch (AvroRuntimeException e) {
            if (e.getMessage().contains("Not a valid schema field")) {
                avroColumnValue = null;
            }
            throw e;
        }
        return new ObjectValueProvider(avroColumnValue, this.columnType, this.columnName);
    }

    private static Object locateNode(GenericRecord element, String columnMapping) {
        Object value = element;
        for (String pathElement : Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)columnMapping)) {
            if (value == null) {
                return null;
            }
            value = value.get(pathElement);
        }
        return value;
    }

    private static Slice getSlice(Object value, Type type, String columnName) {
        if (type instanceof VarcharType && (value instanceof CharSequence || value instanceof GenericEnumSymbol)) {
            return Varchars.truncateToLength((Slice)Slices.utf8Slice((String)value.toString()), (Type)type);
        }
        if (type instanceof VarbinaryType) {
            if (value instanceof ByteBuffer) {
                return Slices.wrappedHeapBuffer((ByteBuffer)((ByteBuffer)value));
            }
            if (value instanceof GenericFixed) {
                return Slices.wrappedBuffer((byte[])((GenericFixed)value).bytes());
            }
        }
        throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", value.getClass(), type, columnName));
    }

    private static Object serializeObject(BlockBuilder builder, Object value, Type type, String columnName) {
        if (type instanceof ArrayType) {
            return AvroColumnDecoder.serializeList(builder, value, type, columnName);
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            return AvroColumnDecoder.serializeMap(builder, value, mapType, columnName);
        }
        if (type instanceof RowType) {
            return AvroColumnDecoder.serializeRow(builder, value, type, columnName);
        }
        AvroColumnDecoder.serializePrimitive(builder, value, type, columnName);
        return null;
    }

    private static Block serializeList(BlockBuilder parentBlockBuilder, Object value, Type type, String columnName) {
        if (value == null) {
            Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parentBlockBuilder is null");
            parentBlockBuilder.appendNull();
            return null;
        }
        List list = (List)value;
        List typeParameters = type.getTypeParameters();
        Type elementType = (Type)typeParameters.get(0);
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, list.size());
        for (Object element : list) {
            AvroColumnDecoder.serializeObject(blockBuilder, element, elementType, columnName);
        }
        if (parentBlockBuilder != null) {
            type.writeObject(parentBlockBuilder, (Object)blockBuilder.build());
            return null;
        }
        return blockBuilder.build();
    }

    private static void serializePrimitive(BlockBuilder blockBuilder, Object value, Type type, String columnName) {
        Objects.requireNonNull(blockBuilder, "blockBuilder is null");
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        if (type instanceof BooleanType) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
            return;
        }
        if ((value instanceof Integer || value instanceof Long) && (type instanceof BigintType || type instanceof IntegerType || type instanceof SmallintType || type instanceof TinyintType)) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
            return;
        }
        if (type instanceof DoubleType) {
            type.writeDouble(blockBuilder, ((Double)value).doubleValue());
            return;
        }
        if (type instanceof RealType) {
            type.writeLong(blockBuilder, (long)Float.floatToIntBits(((Float)value).floatValue()));
            return;
        }
        if (type instanceof VarcharType || type instanceof VarbinaryType) {
            type.writeSlice(blockBuilder, AvroColumnDecoder.getSlice(value, type, columnName));
            return;
        }
        throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", value.getClass(), type, columnName));
    }

    private static SqlMap serializeMap(BlockBuilder parentBlockBuilder, Object value, MapType type, String columnName) {
        if (value == null) {
            Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parentBlockBuilder is null");
            parentBlockBuilder.appendNull();
            return null;
        }
        Map map = (Map)value;
        Type keyType = type.getKeyType();
        Type valueType = type.getValueType();
        if (parentBlockBuilder != null) {
            ((MapBlockBuilder)parentBlockBuilder).buildEntry((keyBuilder, valueBuilder) -> AvroColumnDecoder.buildMap(columnName, map, keyType, valueType, keyBuilder, valueBuilder));
            return null;
        }
        return MapValueBuilder.buildMapValue((MapType)type, (int)map.size(), (keyBuilder, valueBuilder) -> AvroColumnDecoder.buildMap(columnName, map, keyType, valueType, keyBuilder, valueBuilder));
    }

    private static void buildMap(String columnName, Map<?, ?> map, Type keyType, Type valueType, BlockBuilder keyBuilder, BlockBuilder valueBuilder) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getKey() == null) continue;
            keyType.writeSlice(keyBuilder, Varchars.truncateToLength((Slice)Slices.utf8Slice((String)entry.getKey().toString()), (Type)keyType));
            AvroColumnDecoder.serializeObject(valueBuilder, entry.getValue(), valueType, columnName);
        }
    }

    private static SqlRow serializeRow(BlockBuilder blockBuilder, Object value, Type type, String columnName) {
        if (value == null) {
            Preconditions.checkState((blockBuilder != null ? 1 : 0) != 0, (Object)"block builder is null");
            blockBuilder.appendNull();
            return null;
        }
        RowType rowType = (RowType)type;
        if (blockBuilder == null) {
            return RowValueBuilder.buildRowValue((RowType)rowType, fieldBuilders -> AvroColumnDecoder.buildRow(rowType, columnName, (GenericRecord)value, fieldBuilders));
        }
        ((RowBlockBuilder)blockBuilder).buildEntry(fieldBuilders -> AvroColumnDecoder.buildRow(rowType, columnName, (GenericRecord)value, fieldBuilders));
        return null;
    }

    private static void buildRow(RowType type, String columnName, GenericRecord record, List<BlockBuilder> fieldBuilders) {
        List fields = type.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            RowType.Field field = (RowType.Field)fields.get(i);
            Preconditions.checkState((boolean)field.getName().isPresent(), (Object)"field name not found");
            AvroColumnDecoder.serializeObject(fieldBuilders.get(i), record.get((String)field.getName().get()), field.getType(), columnName);
        }
    }

    static class ObjectValueProvider
    extends FieldValueProvider {
        private final Object value;
        private final Type columnType;
        private final String columnName;

        public ObjectValueProvider(Object value, Type columnType, String columnName) {
            this.value = value;
            this.columnType = columnType;
            this.columnName = columnName;
        }

        @Override
        public boolean isNull() {
            return this.value == null;
        }

        @Override
        public double getDouble() {
            if (this.value instanceof Double) {
                return ((Number)this.value).doubleValue();
            }
            throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
        }

        @Override
        public boolean getBoolean() {
            if (this.value instanceof Boolean) {
                return (Boolean)this.value;
            }
            throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
        }

        @Override
        public long getLong() {
            if (this.value instanceof Long || this.value instanceof Integer) {
                return ((Number)this.value).longValue();
            }
            if (this.value instanceof Float && this.columnType == RealType.REAL) {
                return Float.floatToIntBits(((Float)this.value).floatValue());
            }
            throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
        }

        @Override
        public Slice getSlice() {
            return AvroColumnDecoder.getSlice(this.value, this.columnType, this.columnName);
        }

        @Override
        public Object getObject() {
            return AvroColumnDecoder.serializeObject(null, this.value, this.columnType, this.columnName);
        }
    }
}

