/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.protobuf;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.DynamicMessage;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.RowDecoder;
import io.trino.decoder.protobuf.DescriptorProvider;
import io.trino.decoder.protobuf.DynamicMessageProvider;
import io.trino.decoder.protobuf.ProtobufColumnDecoder;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;

public class ProtobufRowDecoder
implements RowDecoder {
    public static final String NAME = "protobuf";
    private final DynamicMessageProvider dynamicMessageProvider;
    private final Map<DecoderColumnHandle, ProtobufColumnDecoder> columnDecoders;

    public ProtobufRowDecoder(DynamicMessageProvider dynamicMessageProvider, Set<DecoderColumnHandle> columns, TypeManager typeManager, DescriptorProvider descriptorProvider) {
        this.dynamicMessageProvider = Objects.requireNonNull(dynamicMessageProvider, "dynamicMessageSupplier is null");
        this.columnDecoders = (Map)columns.stream().collect(ImmutableMap.toImmutableMap(UnaryOperator.identity(), column -> new ProtobufColumnDecoder((DecoderColumnHandle)column, typeManager, descriptorProvider)));
    }

    @Override
    public Optional<Map<DecoderColumnHandle, FieldValueProvider>> decodeRow(byte[] data) {
        DynamicMessage message = this.dynamicMessageProvider.parseDynamicMessage(data);
        return Optional.of((Map)this.columnDecoders.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ProtobufColumnDecoder)entry.getValue()).decodeField(message))));
    }
}

