/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.protobuf;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.protobuf.DescriptorProvider;
import io.trino.decoder.protobuf.ProtobufValueProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ProtobufColumnDecoder {
    private static final ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true)).build();
    private static final String ANY_TYPE_NAME = "google.protobuf.Any";
    private static final Slice EMPTY_JSON = Slices.utf8Slice((String)"{}");
    private static final Set<Type> SUPPORTED_PRIMITIVE_TYPES = ImmutableSet.of((Object)BooleanType.BOOLEAN, (Object)TinyintType.TINYINT, (Object)SmallintType.SMALLINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)RealType.REAL, (Object[])new Type[]{DoubleType.DOUBLE, VarbinaryType.VARBINARY});
    private final Type columnType;
    private final String columnMapping;
    private final String columnName;
    private final TypeManager typeManager;
    private final DescriptorProvider descriptorProvider;
    private final Type jsonType;

    public ProtobufColumnDecoder(DecoderColumnHandle columnHandle, TypeManager typeManager, DescriptorProvider descriptorProvider) {
        try {
            Objects.requireNonNull(columnHandle, "columnHandle is null");
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
            this.descriptorProvider = Objects.requireNonNull(descriptorProvider, "descriptorProvider is null");
            this.jsonType = typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
            this.columnType = columnHandle.getType();
            this.columnMapping = columnHandle.getMapping();
            this.columnName = columnHandle.getName();
            Preconditions.checkArgument((!columnHandle.isInternal() ? 1 : 0) != 0, (String)"unexpected internal column '%s'", (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getFormatHint() == null ? 1 : 0) != 0, (String)"unexpected format hint '%s' defined for column '%s'", (Object)columnHandle.getFormatHint(), (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getDataFormat() == null ? 1 : 0) != 0, (String)"unexpected data format '%s' defined for column '%s'", (Object)columnHandle.getDataFormat(), (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getMapping() != null ? 1 : 0) != 0, (String)"mapping not defined for column '%s'", (Object)this.columnName);
            Preconditions.checkArgument((boolean)this.isSupportedType(this.columnType), (String)"Unsupported column type '%s' for column '%s'", (Object)this.columnType, (Object)this.columnName);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (Throwable)e);
        }
    }

    private boolean isSupportedType(Type type) {
        if (ProtobufColumnDecoder.isSupportedPrimitive(type)) {
            return true;
        }
        if (type instanceof ArrayType) {
            Preconditions.checkArgument((type.getTypeParameters().size() == 1 ? 1 : 0) != 0, (Object)"expecting exactly one type parameter for array");
            return this.isSupportedType((Type)type.getTypeParameters().get(0));
        }
        if (type instanceof MapType) {
            List typeParameters = type.getTypeParameters();
            Preconditions.checkArgument((typeParameters.size() == 2 ? 1 : 0) != 0, (Object)"expecting exactly two type parameters for map");
            return this.isSupportedType((Type)typeParameters.get(0)) && this.isSupportedType((Type)type.getTypeParameters().get(1));
        }
        if (type instanceof RowType) {
            for (Type fieldType : type.getTypeParameters()) {
                if (this.isSupportedType(fieldType)) continue;
                return false;
            }
            return true;
        }
        return type.equals(this.jsonType);
    }

    private static boolean isSupportedPrimitive(Type type) {
        return type instanceof TimestampType && ((TimestampType)type).isShort() || type instanceof VarcharType || SUPPORTED_PRIMITIVE_TYPES.contains(type);
    }

    public FieldValueProvider decodeField(DynamicMessage dynamicMessage) {
        return new ProtobufValueProvider(this.locateField(dynamicMessage, this.columnMapping), this.columnType, this.columnName, this.typeManager);
    }

    @Nullable
    private Object locateField(DynamicMessage message, String columnMapping) {
        Object value = message;
        Optional<Descriptors.Descriptor> valueDescriptor = Optional.of(message.getDescriptorForType());
        for (String pathElement : Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)columnMapping)) {
            if (valueDescriptor.filter(descriptor -> descriptor.findFieldByName(pathElement) != null).isEmpty()) {
                Optional<Descriptors.OneofDescriptor> oneofDescriptor = message.getDescriptorForType().getOneofs().stream().filter(descriptor -> descriptor.getName().equals(columnMapping)).findFirst();
                return oneofDescriptor.map(descriptor -> ProtobufColumnDecoder.createOneofJson(message, descriptor)).orElse(null);
            }
            Descriptors.FieldDescriptor fieldDescriptor = valueDescriptor.get().findFieldByName(pathElement);
            value = value.getField(fieldDescriptor);
            valueDescriptor = ProtobufColumnDecoder.getDescriptor(fieldDescriptor);
        }
        if (valueDescriptor.isPresent() && valueDescriptor.get().getFullName().equals(ANY_TYPE_NAME)) {
            return this.createAnyJson((Message)value, valueDescriptor.get());
        }
        return value;
    }

    private static Optional<Descriptors.Descriptor> getDescriptor(Descriptors.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return Optional.of(fieldDescriptor.getMessageType());
        }
        return Optional.empty();
    }

    private static Object createOneofJson(DynamicMessage message, Descriptors.OneofDescriptor descriptor) {
        Set oneofColumns = (Set)descriptor.getFields().stream().map(Descriptors.FieldDescriptor::getName).collect(ImmutableSet.toImmutableSet());
        List oneofFields = (List)message.getAllFields().entrySet().stream().filter(entry -> oneofColumns.contains(((Descriptors.FieldDescriptor)entry.getKey()).getName())).collect(ImmutableList.toImmutableList());
        if (oneofFields.size() > 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Expected to find at most one 'oneof' field in message, found fields: %s", oneofFields));
        }
        if (!oneofFields.isEmpty()) {
            try {
                Map.Entry oneofField = (Map.Entry)oneofFields.get(0);
                DynamicMessage oneofMessage = DynamicMessage.newBuilder((Descriptors.Descriptor)((Descriptors.FieldDescriptor)oneofField.getKey()).getContainingType()).setField((Descriptors.FieldDescriptor)oneofField.getKey(), oneofField.getValue()).build();
                return Slices.utf8Slice((String)JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)oneofMessage));
            }
            catch (Exception e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to convert oneof message to JSON", (Throwable)e);
            }
        }
        return EMPTY_JSON;
    }

    private Object createAnyJson(Message value, Descriptors.Descriptor valueDescriptor) {
        try {
            String typeUrl = (String)value.getField(valueDescriptor.findFieldByName("type_url"));
            Optional<Descriptors.Descriptor> descriptor = this.descriptorProvider.getDescriptorFromTypeUrl(typeUrl);
            if (descriptor.isPresent()) {
                return Slices.utf8Slice((String)ProtobufColumnDecoder.sorted(JsonFormat.printer().usingTypeRegistry(JsonFormat.TypeRegistry.newBuilder().add(descriptor.get()).build()).omittingInsignificantWhitespace().print((MessageOrBuilder)value)));
            }
            return null;
        }
        catch (InvalidProtocolBufferException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to print JSON from 'any' message type", (Throwable)e);
        }
    }

    private static String sorted(String json) {
        try {
            return mapper.writeValueAsString(mapper.treeToValue((TreeNode)mapper.readTree(json), Map.class));
        }
        catch (JsonProcessingException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to process JSON", (Throwable)e);
        }
    }
}

