/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.protobuf;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.protobuf.ProtobufValueProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class ProtobufColumnDecoder {
    private static final Set<Type> SUPPORTED_PRIMITIVE_TYPES = ImmutableSet.of((Object)BooleanType.BOOLEAN, (Object)TinyintType.TINYINT, (Object)SmallintType.SMALLINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)RealType.REAL, (Object[])new Type[]{DoubleType.DOUBLE, VarbinaryType.VARBINARY});
    private final Type columnType;
    private final String columnMapping;
    private final String columnName;

    public ProtobufColumnDecoder(DecoderColumnHandle columnHandle) {
        try {
            Objects.requireNonNull(columnHandle, "columnHandle is null");
            this.columnType = columnHandle.getType();
            this.columnMapping = columnHandle.getMapping();
            this.columnName = columnHandle.getName();
            Preconditions.checkArgument((!columnHandle.isInternal() ? 1 : 0) != 0, (String)"unexpected internal column '%s'", (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getFormatHint() == null ? 1 : 0) != 0, (String)"unexpected format hint '%s' defined for column '%s'", (Object)columnHandle.getFormatHint(), (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getDataFormat() == null ? 1 : 0) != 0, (String)"unexpected data format '%s' defined for column '%s'", (Object)columnHandle.getDataFormat(), (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getMapping() != null ? 1 : 0) != 0, (String)"mapping not defined for column '%s'", (Object)this.columnName);
            Preconditions.checkArgument((boolean)ProtobufColumnDecoder.isSupportedType(this.columnType), (String)"Unsupported column type '%s' for column '%s'", (Object)this.columnType, (Object)this.columnName);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (Throwable)e);
        }
    }

    private static boolean isSupportedType(Type type) {
        if (ProtobufColumnDecoder.isSupportedPrimitive(type)) {
            return true;
        }
        if (type instanceof ArrayType) {
            Preconditions.checkArgument((type.getTypeParameters().size() == 1 ? 1 : 0) != 0, (Object)"expecting exactly one type parameter for array");
            return ProtobufColumnDecoder.isSupportedType((Type)type.getTypeParameters().get(0));
        }
        if (type instanceof MapType) {
            List typeParameters = type.getTypeParameters();
            Preconditions.checkArgument((typeParameters.size() == 2 ? 1 : 0) != 0, (Object)"expecting exactly two type parameters for map");
            return ProtobufColumnDecoder.isSupportedType((Type)typeParameters.get(0)) && ProtobufColumnDecoder.isSupportedType((Type)type.getTypeParameters().get(1));
        }
        if (type instanceof RowType) {
            for (Type fieldType : type.getTypeParameters()) {
                if (ProtobufColumnDecoder.isSupportedType(fieldType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isSupportedPrimitive(Type type) {
        return type instanceof TimestampType && ((TimestampType)type).isShort() || type instanceof VarcharType || SUPPORTED_PRIMITIVE_TYPES.contains(type);
    }

    public FieldValueProvider decodeField(DynamicMessage dynamicMessage) {
        return new ProtobufValueProvider(ProtobufColumnDecoder.locateField(dynamicMessage, this.columnMapping), this.columnType, this.columnName);
    }

    @Nullable
    private static Object locateField(DynamicMessage message, String columnMapping) {
        Object value = message;
        Optional<Descriptors.Descriptor> valueDescriptor = Optional.of(message.getDescriptorForType());
        for (String pathElement : Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)columnMapping)) {
            if (valueDescriptor.filter(descriptor -> descriptor.findFieldByName(pathElement) != null).isEmpty()) {
                return null;
            }
            Descriptors.FieldDescriptor fieldDescriptor = valueDescriptor.get().findFieldByName(pathElement);
            value = value.getField(fieldDescriptor);
            valueDescriptor = ProtobufColumnDecoder.getDescriptor(fieldDescriptor);
        }
        return value;
    }

    private static Optional<Descriptors.Descriptor> getDescriptor(Descriptors.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return Optional.of(fieldDescriptor.getMessageType());
        }
        return Optional.empty();
    }
}

