/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.avro;

import io.trino.decoder.avro.AvroDeserializer;
import io.trino.decoder.avro.AvroReaderSupplier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.io.DatumReader;

public class AvroFileDeserializer<T>
implements AvroDeserializer<T> {
    public static final String NAME = "file";
    private final AvroReaderSupplier<T> avroReaderSupplier;

    public AvroFileDeserializer(AvroReaderSupplier<T> avroReaderSupplier) {
        this.avroReaderSupplier = Objects.requireNonNull(avroReaderSupplier, "datumReaderSupplier is null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T deserialize(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        DatumReader<T> avroReader = this.avroReaderSupplier.get(buffer);
        try (DataFileStream dataFileReader = new DataFileStream((InputStream)new ByteArrayInputStream(data, buffer.position(), data.length - buffer.position()), avroReader);){
            if (!dataFileReader.hasNext()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "No avro record found");
            }
            Object avroValue = dataFileReader.next();
            if (dataFileReader.hasNext()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unexpected extra record found");
            }
            Object object = avroValue;
            return (T)object;
        }
        catch (IOException | AvroRuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Decoding Avro record failed.", e);
        }
    }

    public static class Factory
    implements AvroDeserializer.Factory {
        @Override
        public <T> AvroDeserializer<T> create(AvroReaderSupplier<T> avroReaderSupplier) {
            return new AvroFileDeserializer<T>(avroReaderSupplier);
        }
    }
}

