/*
 * Decompiled with CFR 0.152.
 */
package io.trino.proxy;

import com.google.common.collect.ListMultimap;
import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import io.airlift.http.client.HeaderName;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.trino.proxy.ProxyException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class ProxyResponseHandler
implements ResponseHandler<ProxyResponse, RuntimeException> {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.create((String)"application", (String)"json");

    public ProxyResponse handleException(Request request, Exception exception) {
        throw new ProxyException("Request to remote Trino server failed", exception);
    }

    public ProxyResponse handle(Request request, Response response) {
        if (response.getStatusCode() == HttpStatus.NO_CONTENT.code()) {
            return new ProxyResponse((ListMultimap<HeaderName, String>)response.getHeaders(), new byte[0]);
        }
        if (response.getStatusCode() != HttpStatus.OK.code()) {
            throw new ProxyException(String.format("Bad status code from remote Trino server: %s: %s", response.getStatusCode(), ProxyResponseHandler.readBody(response)));
        }
        String contentType = response.getHeader("Content-Type");
        if (contentType == null) {
            throw new ProxyException("No Content-Type set in response from remote Trino server");
        }
        if (!MediaType.parse((String)contentType).is(MEDIA_TYPE_JSON)) {
            throw new ProxyException("Bad Content-Type from remote Trino server:" + contentType);
        }
        try {
            return new ProxyResponse((ListMultimap<HeaderName, String>)response.getHeaders(), ByteStreams.toByteArray((InputStream)response.getInputStream()));
        }
        catch (IOException e) {
            throw new ProxyException("Failed reading response from remote Trino server", e);
        }
    }

    private static String readBody(Response response) {
        try {
            return new String(ByteStreams.toByteArray((InputStream)response.getInputStream()), StandardCharsets.US_ASCII);
        }
        catch (IOException e) {
            return "";
        }
    }

    public static class ProxyResponse {
        private final ListMultimap<HeaderName, String> headers;
        private final byte[] body;

        private ProxyResponse(ListMultimap<HeaderName, String> headers, byte[] body) {
            this.headers = Objects.requireNonNull(headers, "headers is null");
            this.body = Objects.requireNonNull(body, "body is null");
        }

        public ListMultimap<HeaderName, String> getHeaders() {
            return this.headers;
        }

        public byte[] getBody() {
            return this.body;
        }
    }
}

