/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;

@DefunctConfig(value={"postgresql.disable-automatic-fetch-size"})
public class PostgreSqlConfig {
    private ArrayMapping arrayMapping = ArrayMapping.DISABLED;
    private boolean includeSystemTables;
    private boolean enableStringPushdownWithCollate;
    private Integer fetchSize;

    @NotNull
    public ArrayMapping getArrayMapping() {
        return this.arrayMapping;
    }

    @Config(value="postgresql.array-mapping")
    @LegacyConfig(value={"postgresql.experimental.array-mapping"})
    public PostgreSqlConfig setArrayMapping(ArrayMapping arrayMapping) {
        this.arrayMapping = arrayMapping;
        return this;
    }

    public boolean isIncludeSystemTables() {
        return this.includeSystemTables;
    }

    @Config(value="postgresql.include-system-tables")
    public PostgreSqlConfig setIncludeSystemTables(boolean includeSystemTables) {
        this.includeSystemTables = includeSystemTables;
        return this;
    }

    public boolean isEnableStringPushdownWithCollate() {
        return this.enableStringPushdownWithCollate;
    }

    @Config(value="postgresql.experimental.enable-string-pushdown-with-collate")
    public PostgreSqlConfig setEnableStringPushdownWithCollate(boolean enableStringPushdownWithCollate) {
        this.enableStringPushdownWithCollate = enableStringPushdownWithCollate;
        return this;
    }

    public Optional<@Min(value=0L) Integer> getFetchSize() {
        return Optional.ofNullable(this.fetchSize);
    }

    @Config(value="postgresql.fetch-size")
    @ConfigDescription(value="Postgresql fetch size, trino specific heuristic is applied if empty")
    public PostgreSqlConfig setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public static enum ArrayMapping {
        DISABLED,
        AS_ARRAY,
        AS_JSON;

    }
}

