/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.plugin.jmx.JmxPlugin;
import io.trino.plugin.postgresql.PostgreSqlPlugin;
import io.trino.plugin.postgresql.TestingPostgreSqlServer;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tpch.TpchTable;
import java.util.HashMap;
import java.util.Map;

public final class PostgreSqlQueryRunner {
    private static final String TPCH_SCHEMA = "tpch";

    private PostgreSqlQueryRunner() {
    }

    public static DistributedQueryRunner createPostgreSqlQueryRunner(TestingPostgreSqlServer server, Map<String, String> extraProperties, Map<String, String> connectorProperties, Iterable<TpchTable<?>> tables) throws Exception {
        DistributedQueryRunner queryRunner = null;
        try {
            queryRunner = DistributedQueryRunner.builder((Session)PostgreSqlQueryRunner.createSession()).setExtraProperties(extraProperties).build();
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog(TPCH_SCHEMA, TPCH_SCHEMA);
            connectorProperties = new HashMap<String, String>((Map<String, String>)ImmutableMap.copyOf(connectorProperties));
            connectorProperties.putIfAbsent("connection-url", server.getJdbcUrl());
            connectorProperties.putIfAbsent("connection-user", server.getUser());
            connectorProperties.putIfAbsent("connection-password", server.getPassword());
            connectorProperties.putIfAbsent("allow-drop-table", "true");
            connectorProperties.putIfAbsent("postgresql.include-system-tables", "true");
            queryRunner.installPlugin((Plugin)new PostgreSqlPlugin());
            queryRunner.createCatalog("postgresql", "postgresql", connectorProperties);
            QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)TPCH_SCHEMA, (String)"tiny", (Session)PostgreSqlQueryRunner.createSession(), tables);
            return queryRunner;
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner, server});
            throw e;
        }
    }

    public static Session createSession() {
        return TestingSession.testSessionBuilder().setCatalog("postgresql").setSchema(TPCH_SCHEMA).build();
    }

    public static void main(String[] args) throws Exception {
        Logging.initialize();
        DistributedQueryRunner queryRunner = PostgreSqlQueryRunner.createPostgreSqlQueryRunner(new TestingPostgreSqlServer(), (Map<String, String>)ImmutableMap.of((Object)"http-server.http.port", (Object)"8080"), (Map<String, String>)ImmutableMap.of(), TpchTable.getTables());
        queryRunner.installPlugin((Plugin)new JmxPlugin());
        queryRunner.createCatalog("jmx", "jmx");
        Logger log = Logger.get(PostgreSqlQueryRunner.class);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }
}

