/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.util;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.AbstractInvocationHandler;
import io.airlift.units.Duration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class LoggingInvocationHandler
extends AbstractInvocationHandler {
    private final Object delegate;
    private final Consumer<String> logger;
    private final boolean includeResult;

    public LoggingInvocationHandler(Object delegate, Consumer<String> logger) {
        this(delegate, logger, false);
    }

    public LoggingInvocationHandler(Object delegate, Consumer<String> logger, boolean includeResult) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.logger = Objects.requireNonNull(logger, "logger is null");
        this.includeResult = includeResult;
    }

    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        long startNanos = System.nanoTime();
        try {
            result = method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException e) {
            Duration elapsed = Duration.nanosSince((long)startNanos);
            Throwable t = e.getCause();
            this.logger.accept(String.format("%s took %s and failed with %s", LoggingInvocationHandler.invocationDescription(method, args), elapsed, t));
            throw t;
        }
        Duration elapsed = Duration.nanosSince((long)startNanos);
        if (this.includeResult) {
            this.logger.accept(String.format("%s succeeded in %s and returned %s", LoggingInvocationHandler.invocationDescription(method, args), elapsed, LoggingInvocationHandler.formatArgument(result)));
        } else {
            this.logger.accept(String.format("%s succeeded in %s", LoggingInvocationHandler.invocationDescription(method, args), elapsed));
        }
        return result;
    }

    private static String invocationDescription(Method method, Object[] args) {
        Optional<List<String>> parameterNames = LoggingInvocationHandler.getParameterNames(method);
        return "Invocation of " + method.getName() + IntStream.range(0, args.length).mapToObj(i -> {
            if (parameterNames.isPresent()) {
                return String.format("%s=%s", ((List)parameterNames.get()).get(i), LoggingInvocationHandler.formatArgument(args[i]));
            }
            return LoggingInvocationHandler.formatArgument(args[i]);
        }).collect(Collectors.joining(", ", "(", ")"));
    }

    private static String formatArgument(Object arg) {
        if (arg instanceof String) {
            String string = (String)arg;
            return "'" + string.replace("'", "''") + "'";
        }
        return String.valueOf(arg);
    }

    private static Optional<List<String>> getParameterNames(Method method) {
        Parameter[] parameters = method.getParameters();
        if (Arrays.stream(parameters).noneMatch(Parameter::isNamePresent)) {
            return Optional.empty();
        }
        return Arrays.stream(parameters).map(Parameter::getName).collect(Collectors.collectingAndThen(ImmutableList.toImmutableList(), Optional::of));
    }
}

