/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.SchemaRoutineName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public abstract class ForwardingConnectorAccessControl
implements ConnectorAccessControl {
    public static ConnectorAccessControl of(final Supplier<ConnectorAccessControl> connectorAccessControlSupplier) {
        Objects.requireNonNull(connectorAccessControlSupplier, "connectorAccessControlSupplier is null");
        return new ForwardingConnectorAccessControl(){

            @Override
            protected ConnectorAccessControl delegate() {
                return (ConnectorAccessControl)connectorAccessControlSupplier.get();
            }
        };
    }

    protected abstract ConnectorAccessControl delegate();

    public void checkCanCreateSchema(ConnectorSecurityContext context, String schemaName, Map<String, Object> properties) {
        this.delegate().checkCanCreateSchema(context, schemaName, properties);
    }

    public void checkCanDropSchema(ConnectorSecurityContext context, String schemaName) {
        this.delegate().checkCanDropSchema(context, schemaName);
    }

    public void checkCanRenameSchema(ConnectorSecurityContext context, String schemaName, String newSchemaName) {
        this.delegate().checkCanRenameSchema(context, schemaName, newSchemaName);
    }

    public void checkCanSetSchemaAuthorization(ConnectorSecurityContext context, String schemaName, TrinoPrincipal principal) {
        this.delegate().checkCanSetSchemaAuthorization(context, schemaName, principal);
    }

    public void checkCanShowSchemas(ConnectorSecurityContext context) {
        this.delegate().checkCanShowSchemas(context);
    }

    public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        return this.delegate().filterSchemas(context, schemaNames);
    }

    public void checkCanShowCreateSchema(ConnectorSecurityContext context, String schemaName) {
        this.delegate().checkCanShowCreateSchema(context, schemaName);
    }

    public void checkCanShowCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        this.delegate().checkCanShowCreateTable(context, tableName);
    }

    public void checkCanCreateTable(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Object> properties) {
        this.delegate().checkCanCreateTable(context, tableName, properties);
    }

    public void checkCanDropTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        this.delegate().checkCanDropTable(context, tableName);
    }

    public void checkCanRenameTable(ConnectorSecurityContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        this.delegate().checkCanRenameTable(context, tableName, newTableName);
    }

    public void checkCanSetTableProperties(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Optional<Object>> properties) {
        this.delegate().checkCanSetTableProperties(context, tableName, properties);
    }

    public void checkCanSetTableComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        this.delegate().checkCanSetTableComment(context, tableName);
    }

    public void checkCanSetViewComment(ConnectorSecurityContext context, SchemaTableName viewName) {
        this.delegate().checkCanSetViewComment(context, viewName);
    }

    public void checkCanSetColumnComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        this.delegate().checkCanSetColumnComment(context, tableName);
    }

    public void checkCanShowTables(ConnectorSecurityContext context, String schemaName) {
        this.delegate().checkCanShowTables(context, schemaName);
    }

    public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        return this.delegate().filterTables(context, tableNames);
    }

    public void checkCanShowColumns(ConnectorSecurityContext context, SchemaTableName tableName) {
        this.delegate().checkCanShowColumns(context, tableName);
    }

    public Map<SchemaTableName, Set<String>> filterColumns(ConnectorSecurityContext context, Map<SchemaTableName, Set<String>> tableColumns) {
        return this.delegate().filterColumns(context, tableColumns);
    }

    public void checkCanAddColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        this.delegate().checkCanAddColumn(context, tableName);
    }

    public void checkCanDropColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        this.delegate().checkCanDropColumn(context, tableName);
    }

    public void checkCanRenameColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        this.delegate().checkCanRenameColumn(context, tableName);
    }

    public void checkCanAlterColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        this.delegate().checkCanAlterColumn(context, tableName);
    }

    public void checkCanSetTableAuthorization(ConnectorSecurityContext context, SchemaTableName tableName, TrinoPrincipal principal) {
        this.delegate().checkCanSetTableAuthorization(context, tableName, principal);
    }

    public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        this.delegate().checkCanSelectFromColumns(context, tableName, columnNames);
    }

    public void checkCanInsertIntoTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        this.delegate().checkCanInsertIntoTable(context, tableName);
    }

    public void checkCanDeleteFromTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        this.delegate().checkCanDeleteFromTable(context, tableName);
    }

    public void checkCanTruncateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        this.delegate().checkCanTruncateTable(context, tableName);
    }

    public void checkCanUpdateTableColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> updatedColumns) {
        this.delegate().checkCanUpdateTableColumns(context, tableName, updatedColumns);
    }

    public void checkCanCreateView(ConnectorSecurityContext context, SchemaTableName viewName) {
        this.delegate().checkCanCreateView(context, viewName);
    }

    public void checkCanRenameView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        this.delegate().checkCanRenameView(context, viewName, newViewName);
    }

    public void checkCanRefreshView(ConnectorSecurityContext context, SchemaTableName viewName) {
        this.delegate().checkCanRefreshView(context, viewName);
    }

    public void checkCanSetViewAuthorization(ConnectorSecurityContext context, SchemaTableName viewName, TrinoPrincipal principal) {
        this.delegate().checkCanSetViewAuthorization(context, viewName, principal);
    }

    public void checkCanDropView(ConnectorSecurityContext context, SchemaTableName viewName) {
        this.delegate().checkCanDropView(context, viewName);
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
        this.delegate().checkCanCreateViewWithSelectFromColumns(context, tableName, columnNames);
    }

    public void checkCanCreateMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Object> properties) {
        this.delegate().checkCanCreateMaterializedView(context, materializedViewName, properties);
    }

    public void checkCanRefreshMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
        this.delegate().checkCanRefreshMaterializedView(context, materializedViewName);
    }

    public void checkCanDropMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
        this.delegate().checkCanDropMaterializedView(context, materializedViewName);
    }

    public void checkCanRenameMaterializedView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        this.delegate().checkCanRenameMaterializedView(context, viewName, newViewName);
    }

    public void checkCanSetMaterializedViewAuthorization(ConnectorSecurityContext context, SchemaTableName viewName, TrinoPrincipal principal) {
        this.delegate().checkCanSetMaterializedViewAuthorization(context, viewName, principal);
    }

    public void checkCanSetMaterializedViewProperties(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Optional<Object>> properties) {
        this.delegate().checkCanSetMaterializedViewProperties(context, materializedViewName, properties);
    }

    public void checkCanSetCatalogSessionProperty(ConnectorSecurityContext context, String propertyName) {
        this.delegate().checkCanSetCatalogSessionProperty(context, propertyName);
    }

    public void checkCanGrantSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee, boolean grantOption) {
        this.delegate().checkCanGrantSchemaPrivilege(context, privilege, schemaName, grantee, grantOption);
    }

    public void checkCanDenySchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee) {
        this.delegate().checkCanDenySchemaPrivilege(context, privilege, schemaName, grantee);
    }

    public void checkCanRevokeSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal revokee, boolean grantOption) {
        this.delegate().checkCanRevokeSchemaPrivilege(context, privilege, schemaName, revokee, grantOption);
    }

    public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee, boolean grantOption) {
        this.delegate().checkCanGrantTablePrivilege(context, privilege, tableName, grantee, grantOption);
    }

    public void checkCanDenyTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee) {
        this.delegate().checkCanDenyTablePrivilege(context, privilege, tableName, grantee);
    }

    public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal revokee, boolean grantOption) {
        this.delegate().checkCanRevokeTablePrivilege(context, privilege, tableName, revokee, grantOption);
    }

    public void checkCanCreateRole(ConnectorSecurityContext context, String role, Optional<TrinoPrincipal> grantor) {
        this.delegate().checkCanCreateRole(context, role, grantor);
    }

    public void checkCanDropRole(ConnectorSecurityContext context, String role) {
        this.delegate().checkCanDropRole(context, role);
    }

    public void checkCanGrantRoles(ConnectorSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        this.delegate().checkCanGrantRoles(context, roles, grantees, adminOption, grantor);
    }

    public void checkCanRevokeRoles(ConnectorSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        this.delegate().checkCanRevokeRoles(context, roles, grantees, adminOption, grantor);
    }

    public void checkCanSetRole(ConnectorSecurityContext context, String role) {
        this.delegate().checkCanSetRole(context, role);
    }

    public void checkCanShowRoles(ConnectorSecurityContext context) {
        this.delegate().checkCanShowRoles(context);
    }

    public void checkCanShowCurrentRoles(ConnectorSecurityContext context) {
        this.delegate().checkCanShowCurrentRoles(context);
    }

    public void checkCanShowRoleGrants(ConnectorSecurityContext context) {
        this.delegate().checkCanShowRoleGrants(context);
    }

    public void checkCanExecuteProcedure(ConnectorSecurityContext context, SchemaRoutineName procedure) {
        this.delegate().checkCanExecuteProcedure(context, procedure);
    }

    public void checkCanExecuteTableProcedure(ConnectorSecurityContext context, SchemaTableName tableName, String procedure) {
        this.delegate().checkCanExecuteTableProcedure(context, tableName, procedure);
    }

    public boolean canExecuteFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
        return this.delegate().canExecuteFunction(context, function);
    }

    public boolean canCreateViewWithExecuteFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
        return this.delegate().canCreateViewWithExecuteFunction(context, function);
    }

    public void checkCanShowFunctions(ConnectorSecurityContext context, String schemaName) {
        this.delegate().checkCanShowFunctions(context, schemaName);
    }

    public Set<SchemaFunctionName> filterFunctions(ConnectorSecurityContext context, Set<SchemaFunctionName> functionNames) {
        return this.delegate().filterFunctions(context, functionNames);
    }

    public void checkCanCreateFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
        this.delegate().checkCanCreateFunction(context, function);
    }

    public void checkCanDropFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
        this.delegate().checkCanDropFunction(context, function);
    }

    public void checkCanShowCreateFunction(ConnectorSecurityContext context, SchemaRoutineName function) {
        this.delegate().checkCanShowCreateFunction(context, function);
    }

    public void checkCanShowBranches(ConnectorSecurityContext context, SchemaTableName tableName) {
        this.delegate().checkCanShowBranches(context, tableName);
    }

    public void checkCanCreateBranch(ConnectorSecurityContext context, SchemaTableName tableName, String branchName) {
        this.delegate().checkCanCreateBranch(context, tableName, branchName);
    }

    public void checkCanDropBranch(ConnectorSecurityContext context, SchemaTableName tableName, String branchName) {
        this.delegate().checkCanDropBranch(context, tableName, branchName);
    }

    public void checkCanFastForwardBranch(ConnectorSecurityContext context, SchemaTableName tableName, String sourceBranchName, String targetBranchName) {
        this.delegate().checkCanFastForwardBranch(context, tableName, sourceBranchName, targetBranchName);
    }

    public void checkCanGrantTableBranchPrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, String branchName, TrinoPrincipal grantee, boolean grantOption) {
        this.delegate().checkCanGrantTableBranchPrivilege(context, privilege, tableName, branchName, grantee, grantOption);
    }

    public void checkCanDenyTableBranchPrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, String branchName, TrinoPrincipal grantee) {
        this.delegate().checkCanDenyTableBranchPrivilege(context, privilege, tableName, branchName, grantee);
    }

    public void checkCanRevokeTableBranchPrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, String branchName, TrinoPrincipal revokee, boolean grantOption) {
        this.delegate().checkCanRevokeTableBranchPrivilege(context, privilege, tableName, branchName, revokee, grantOption);
    }

    public List<ViewExpression> getRowFilters(ConnectorSecurityContext context, SchemaTableName tableName) {
        return this.delegate().getRowFilters(context, tableName);
    }

    public Optional<ViewExpression> getColumnMask(ConnectorSecurityContext context, SchemaTableName tableName, String columnName, Type type) {
        return this.delegate().getColumnMask(context, tableName, columnName, type);
    }

    public Map<ColumnSchema, ViewExpression> getColumnMasks(ConnectorSecurityContext context, SchemaTableName tableName, List<ColumnSchema> columns) {
        return this.delegate().getColumnMasks(context, tableName, columns);
    }
}

