/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.ldap;

import java.util.Arrays;
import java.util.Objects;

public class LdapQuery {
    private final String searchBase;
    private final String searchFilter;
    private final Object[] filterArguments;
    private final String[] attributes;

    private LdapQuery(String searchBase, String searchFilter, Object[] filterArguments, String[] attributes) {
        this.searchBase = Objects.requireNonNull(searchBase, "searchBase is null");
        this.searchFilter = Objects.requireNonNull(searchFilter, "searchFilter is null");
        Objects.requireNonNull(attributes, "attributes is null");
        Objects.requireNonNull(filterArguments, "filterArguments is null");
        this.filterArguments = Arrays.copyOf(filterArguments, filterArguments.length);
        this.attributes = Arrays.copyOf(attributes, attributes.length);
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public String getSearchFilter() {
        return this.searchFilter;
    }

    public Object[] getFilterArguments() {
        return this.filterArguments;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public static class LdapQueryBuilder {
        private String searchBase;
        private String searchFilter;
        private String[] attributes = new String[0];
        private Object[] filterArguments = new Object[0];

        public LdapQueryBuilder withSearchBase(String searchBase) {
            this.searchBase = Objects.requireNonNull(searchBase, "searchBase is null");
            return this;
        }

        public LdapQueryBuilder withSearchFilter(String searchFilter) {
            this.searchFilter = Objects.requireNonNull(searchFilter, "searchFilter is null");
            return this;
        }

        public LdapQueryBuilder withFilterArguments(Object ... arguments) {
            this.filterArguments = Objects.requireNonNull(arguments, "arguments is null");
            return this;
        }

        public LdapQueryBuilder withAttributes(String ... attributes) {
            this.attributes = Objects.requireNonNull(attributes, "attributes is null");
            return this;
        }

        public LdapQuery build() {
            return new LdapQuery(this.searchBase, this.searchFilter, this.filterArguments, this.attributes);
        }
    }
}

