/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.matching.Pattern;
import io.trino.matching.Property;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public final class ConnectorExpressionPatterns {
    private ConnectorExpressionPatterns() {
    }

    public static Pattern<ConnectorExpression> expression() {
        return Pattern.typeOf(ConnectorExpression.class);
    }

    public static Property<ConnectorExpression, ?, Type> type() {
        return Property.property((String)"type", ConnectorExpression::getType);
    }

    public static Pattern<Call> call() {
        return Pattern.typeOf(Call.class);
    }

    public static Property<Call, ?, FunctionName> functionName() {
        return Property.property((String)"functionName", Call::getFunctionName);
    }

    public static Property<Call, ?, String> functionUnqualifiedName() {
        return Property.optionalProperty((String)"functionUnqualifiedName", call -> {
            FunctionName functionName = call.getFunctionName();
            if (functionName.getCatalogSchema().isPresent()) {
                return Optional.empty();
            }
            return Optional.of(functionName.getName());
        });
    }

    public static Property<Call, ?, Integer> argumentCount() {
        return Property.property((String)"argumentCount", call -> call.getArguments().size());
    }

    public static Property<Call, ?, List<ConnectorExpression>> arguments() {
        return Property.property((String)"arguments", Call::getArguments);
    }

    public static Property<Call, ?, ConnectorExpression> argument(int argument) {
        Preconditions.checkArgument((0 <= argument ? 1 : 0) != 0, (String)"Invalid argument index: %s", (int)argument);
        return Property.optionalProperty((String)String.format("argument(%s)", argument), call -> {
            if (argument < call.getArguments().size()) {
                return Optional.of((ConnectorExpression)call.getArguments().get(argument));
            }
            return Optional.empty();
        });
    }

    public static Property<Call, ?, Type> argumentType(int argument) {
        Preconditions.checkArgument((0 <= argument ? 1 : 0) != 0, (String)"Invalid argument index: %s", (int)argument);
        return Property.optionalProperty((String)String.format("argumentType(%s)", argument), call -> {
            if (argument < call.getArguments().size()) {
                return Optional.of(((ConnectorExpression)call.getArguments().get(argument)).getType());
            }
            return Optional.empty();
        });
    }

    public static Property<Call, ?, List<Type>> argumentTypes() {
        return Property.property((String)"argumentTypes", call -> (List)call.getArguments().stream().map(ConnectorExpression::getType).collect(ImmutableList.toImmutableList()));
    }

    public static Pattern<Constant> constant() {
        return Pattern.typeOf(Constant.class);
    }

    public static Pattern<Variable> variable() {
        return Pattern.typeOf(Variable.class);
    }

    public static Predicate<List<? extends ConnectorExpression>> expressionTypes(Type ... types) {
        ImmutableList expectedTypes = ImmutableList.copyOf((Object[])Objects.requireNonNull(types, "types is null"));
        return arg_0 -> ConnectorExpressionPatterns.lambda$expressionTypes$0((List)expectedTypes, arg_0);
    }

    private static /* synthetic */ boolean lambda$expressionTypes$0(List expectedTypes, List expressions) {
        return expectedTypes.equals(expressions.stream().map(ConnectorExpression::getType).collect(ImmutableList.toImmutableList()));
    }
}

