/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.spi.Page;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorPageSink;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ClassLoaderSafeConnectorPageSink
implements ConnectorPageSink {
    private final ConnectorPageSink delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeConnectorPageSink(@ForClassLoaderSafe ConnectorPageSink delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public long getCompletedBytes() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            long l = this.delegate.getCompletedBytes();
            return l;
        }
    }

    public long getMemoryUsage() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            long l = this.delegate.getMemoryUsage();
            return l;
        }
    }

    public long getValidationCpuNanos() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            long l = this.delegate.getValidationCpuNanos();
            return l;
        }
    }

    public CompletableFuture<?> appendPage(Page page) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            CompletableFuture completableFuture = this.delegate.appendPage(page);
            return completableFuture;
        }
    }

    public void closeIdleWriters() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.closeIdleWriters();
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            CompletableFuture completableFuture = this.delegate.finish();
            return completableFuture;
        }
    }

    public void abort() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.abort();
        }
    }
}

