/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class MappedRecordSet
implements RecordSet {
    private final RecordSet delegate;
    private final int[] delegateFieldIndex;
    private final List<Type> columnTypes;

    public MappedRecordSet(RecordSet delegate, List<Integer> delegateFieldIndex) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.delegateFieldIndex = Ints.toArray((Collection)Objects.requireNonNull(delegateFieldIndex, "delegateFieldIndex is null"));
        List types = delegate.getColumnTypes();
        this.columnTypes = (List)delegateFieldIndex.stream().map(types::get).collect(ImmutableList.toImmutableList());
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new MappedRecordCursor(this.delegate.cursor(), this.delegateFieldIndex);
    }

    private static class MappedRecordCursor
    implements RecordCursor {
        private final RecordCursor delegate;
        private final int[] delegateFieldIndex;

        private MappedRecordCursor(RecordCursor delegate, int[] delegateFieldIndex) {
            this.delegate = delegate;
            this.delegateFieldIndex = delegateFieldIndex;
        }

        public long getCompletedBytes() {
            return this.delegate.getCompletedBytes();
        }

        public long getReadTimeNanos() {
            return this.delegate.getReadTimeNanos();
        }

        public Type getType(int field) {
            return this.delegate.getType(this.toDelegateField(field));
        }

        public boolean advanceNextPosition() {
            return this.delegate.advanceNextPosition();
        }

        public boolean getBoolean(int field) {
            return this.delegate.getBoolean(this.toDelegateField(field));
        }

        public long getLong(int field) {
            return this.delegate.getLong(this.toDelegateField(field));
        }

        public double getDouble(int field) {
            return this.delegate.getDouble(this.toDelegateField(field));
        }

        public Slice getSlice(int field) {
            return this.delegate.getSlice(this.toDelegateField(field));
        }

        public Object getObject(int field) {
            return this.delegate.getObject(this.toDelegateField(field));
        }

        public boolean isNull(int field) {
            return this.delegate.isNull(this.toDelegateField(field));
        }

        public void close() {
            this.delegate.close();
        }

        private int toDelegateField(int field) {
            Preconditions.checkElementIndex((int)field, (int)this.delegateFieldIndex.length, (String)"field");
            return this.delegateFieldIndex[field];
        }
    }
}

