/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.metrics;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import io.trino.spi.metrics.Distribution;
import io.trino.spi.metrics.Metric;
import java.util.Locale;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
@JsonSerialize
public record DistributionSnapshot(long total, double min, double max, double p01, double p05, double p10, double p25, double p50, double p75, double p90, double p95, double p99) implements Metric<DistributionSnapshot>
{
    public static DistributionSnapshot fromDistribution(Distribution<?> distribution) {
        double[] percentiles = distribution.getPercentiles(new double[]{1.0, 5.0, 10.0, 25.0, 50.0, 75.0, 90.0, 95.0, 99.0});
        return new DistributionSnapshot(distribution.getTotal(), distribution.getMin(), distribution.getMax(), percentiles[0], percentiles[1], percentiles[2], percentiles[3], percentiles[4], percentiles[5], percentiles[6], percentiles[7], percentiles[8]);
    }

    @Override
    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"").add("count", this.total).add("p01", (Object)DistributionSnapshot.formatDouble(this.p01)).add("p05", (Object)DistributionSnapshot.formatDouble(this.p05)).add("p10", (Object)DistributionSnapshot.formatDouble(this.p10)).add("p25", (Object)DistributionSnapshot.formatDouble(this.p25)).add("p50", (Object)DistributionSnapshot.formatDouble(this.p50)).add("p75", (Object)DistributionSnapshot.formatDouble(this.p75)).add("p90", (Object)DistributionSnapshot.formatDouble(this.p90)).add("p95", (Object)DistributionSnapshot.formatDouble(this.p95)).add("p99", (Object)DistributionSnapshot.formatDouble(this.p99)).add("min", (Object)DistributionSnapshot.formatDouble(this.min)).add("max", (Object)DistributionSnapshot.formatDouble(this.max));
        return helper.toString();
    }

    public DistributionSnapshot mergeWith(DistributionSnapshot other) {
        throw new UnsupportedOperationException("Merging of DistributionSnapshot is not supported");
    }

    private static String formatDouble(double value) {
        return String.format(Locale.US, "%.2f", value);
    }
}

