/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.projection;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.Variable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public final class ApplyProjectionUtil {
    private ApplyProjectionUtil() {
    }

    public static List<ConnectorExpression> extractSupportedProjectedColumns(ConnectorExpression expression) {
        return ApplyProjectionUtil.extractSupportedProjectedColumns(expression, connectorExpression -> true);
    }

    public static List<ConnectorExpression> extractSupportedProjectedColumns(ConnectorExpression expression, Predicate<ConnectorExpression> expressionPredicate) {
        Objects.requireNonNull(expression, "expression is null");
        ImmutableList.Builder supportedSubExpressions = ImmutableList.builder();
        ApplyProjectionUtil.fillSupportedProjectedColumns(expression, (ImmutableList.Builder<ConnectorExpression>)supportedSubExpressions, expressionPredicate);
        return supportedSubExpressions.build();
    }

    private static void fillSupportedProjectedColumns(ConnectorExpression expression, ImmutableList.Builder<ConnectorExpression> supportedSubExpressions, Predicate<ConnectorExpression> expressionPredicate) {
        if (ApplyProjectionUtil.isPushdownSupported(expression, expressionPredicate)) {
            supportedSubExpressions.add((Object)expression);
            return;
        }
        for (ConnectorExpression child : expression.getChildren()) {
            ApplyProjectionUtil.fillSupportedProjectedColumns(child, supportedSubExpressions, expressionPredicate);
        }
    }

    @VisibleForTesting
    static boolean isPushdownSupported(ConnectorExpression expression, Predicate<ConnectorExpression> expressionPredicate) {
        FieldDereference fieldDereference;
        return expressionPredicate.test(expression) && (expression instanceof Variable || expression instanceof FieldDereference && ApplyProjectionUtil.isPushdownSupported((fieldDereference = (FieldDereference)expression).getTarget(), expressionPredicate));
    }

    public static ProjectedColumnRepresentation createProjectedColumnRepresentation(ConnectorExpression expression) {
        Variable variable;
        ImmutableList.Builder ordinals;
        block1: {
            ordinals = ImmutableList.builder();
            while (true) {
                if (expression instanceof Variable) break block1;
                if (!(expression instanceof FieldDereference)) break;
                FieldDereference dereference = (FieldDereference)expression;
                ordinals.add((Object)dereference.getField());
                expression = dereference.getTarget();
            }
            throw new IllegalArgumentException("expression is not a valid dereference chain");
        }
        Variable target = variable = (Variable)expression;
        return new ProjectedColumnRepresentation(target, (List<Integer>)ordinals.build().reverse());
    }

    public static ConnectorExpression replaceWithNewVariables(ConnectorExpression expression, Map<ConnectorExpression, Variable> expressionToVariableMappings) {
        if (expressionToVariableMappings.containsKey(expression)) {
            return (ConnectorExpression)expressionToVariableMappings.get(expression);
        }
        if (expression instanceof Constant || expression instanceof Variable) {
            return expression;
        }
        if (expression instanceof FieldDereference) {
            FieldDereference fieldDereference = (FieldDereference)expression;
            ConnectorExpression newTarget = ApplyProjectionUtil.replaceWithNewVariables(fieldDereference.getTarget(), expressionToVariableMappings);
            return new FieldDereference(expression.getType(), newTarget, fieldDereference.getField());
        }
        if (expression instanceof Call) {
            Call call = (Call)expression;
            return new Call(call.getType(), call.getFunctionName(), (List)call.getArguments().stream().map(argument -> ApplyProjectionUtil.replaceWithNewVariables(argument, expressionToVariableMappings)).collect(ImmutableList.toImmutableList()));
        }
        throw new UnsupportedOperationException("Unsupported expression: " + String.valueOf(expression));
    }

    public static class ProjectedColumnRepresentation {
        private final Variable variable;
        private final List<Integer> dereferenceIndices;

        public ProjectedColumnRepresentation(Variable variable, List<Integer> dereferenceIndices) {
            this.variable = Objects.requireNonNull(variable, "variable is null");
            this.dereferenceIndices = ImmutableList.copyOf((Collection)Objects.requireNonNull(dereferenceIndices, "dereferenceIndices is null"));
        }

        public Variable getVariable() {
            return this.variable;
        }

        public List<Integer> getDereferenceIndices() {
            return this.dereferenceIndices;
        }

        public boolean isVariable() {
            return this.dereferenceIndices.isEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectedColumnRepresentation that = (ProjectedColumnRepresentation)obj;
            return Objects.equals(this.variable, that.variable) && Objects.equals(this.dereferenceIndices, that.dereferenceIndices);
        }

        public int hashCode() {
            return Objects.hash(this.variable, this.dereferenceIndices);
        }
    }
}

