/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.logging;

import io.trino.plugin.base.logging.FormatInterpolator;
import io.trino.spi.connector.ConnectorSession;
import java.util.function.Function;

public enum SessionInterpolatedValues implements FormatInterpolator.InterpolatedValue<ConnectorSession>
{
    QUERY_ID(ConnectorSession::getQueryId),
    SOURCE(session -> session.getSource().orElse("")),
    USER(ConnectorSession::getUser),
    TRACE_TOKEN(session -> session.getTraceToken().orElse(""));

    private final Function<ConnectorSession, String> valueProvider;

    private SessionInterpolatedValues(Function<ConnectorSession, String> valueProvider) {
        this.valueProvider = valueProvider;
    }

    @Override
    public String value(ConnectorSession session) {
        return this.valueProvider.apply(session);
    }
}

