/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.expression;

import com.google.common.base.Verify;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.expression.ConnectorExpression;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public interface ConnectorExpressionRule<ExpressionType extends ConnectorExpression, Result> {
    default public boolean isEnabled(ConnectorSession session) {
        return true;
    }

    public Pattern<ExpressionType> getPattern();

    public Optional<Result> rewrite(ExpressionType var1, Captures var2, RewriteContext<Result> var3);

    public static interface RewriteContext<Result> {
        default public ColumnHandle getAssignment(String name) {
            Objects.requireNonNull(name, "name is null");
            ColumnHandle columnHandle = this.getAssignments().get(name);
            Verify.verifyNotNull((Object)columnHandle, (String)"No assignment for %s", (Object[])new Object[]{name});
            return columnHandle;
        }

        public Map<String, ColumnHandle> getAssignments();

        public ConnectorSession getSession();

        public Optional<Result> defaultRewrite(ConnectorExpression var1);
    }
}

