/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.authentication;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.trino.plugin.base.authentication.KerberosAuthentication;
import io.trino.plugin.base.authentication.KerberosTicketUtils;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;

public class CachingKerberosAuthentication {
    private final KerberosAuthentication kerberosAuthentication;
    @GuardedBy(value="this")
    private Subject subject;
    @GuardedBy(value="this")
    private long nextRefreshTime;

    public CachingKerberosAuthentication(KerberosAuthentication kerberosAuthentication) {
        this.kerberosAuthentication = Objects.requireNonNull(kerberosAuthentication, "kerberosAuthentication is null");
    }

    public synchronized Subject getSubject() {
        if (this.subject == null || this.ticketNeedsRefresh()) {
            this.subject = Objects.requireNonNull(this.kerberosAuthentication.getSubject(), "kerberosAuthentication.getSubject() is null");
            KerberosTicket tgtTicket = KerberosTicketUtils.getTicketGrantingTicket(this.subject);
            this.nextRefreshTime = KerberosTicketUtils.getRefreshTime(tgtTicket);
        }
        return this.subject;
    }

    public synchronized void reauthenticateIfSoonWillBeExpired() {
        Objects.requireNonNull(this.subject, "subject is null, getSubject() must be called before reauthenticate()");
        if (this.ticketNeedsRefresh()) {
            this.kerberosAuthentication.attemptLogin(this.subject);
            KerberosTicket tgtTicket = KerberosTicketUtils.getTicketGrantingTicket(this.subject);
            this.nextRefreshTime = KerberosTicketUtils.getRefreshTime(tgtTicket);
        }
    }

    @GuardedBy(value="this")
    private boolean ticketNeedsRefresh() {
        return this.nextRefreshTime < System.currentTimeMillis();
    }
}

