/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base;

import io.trino.spi.connector.ConnectorSession;
import java.util.HexFormat;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public class TemporaryTables {
    private static final HexFormat hexFormat = HexFormat.of();
    public static final String TEMPORARY_TABLE_NAME_PREFIX = "tmp_trino_";

    public static String temporaryTableNamePrefix(String queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        return String.format("%s%s_", TEMPORARY_TABLE_NAME_PREFIX, hexFormat.toHexDigits(queryId.hashCode()));
    }

    public static String generateTemporaryTableName(String queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        return TemporaryTables.temporaryTableNamePrefix(queryId) + hexFormat.toHexDigits(ThreadLocalRandom.current().nextInt());
    }

    public static String generateTemporaryTableName(ConnectorSession session) {
        Objects.requireNonNull(session, "session is null");
        return TemporaryTables.generateTemporaryTableName(session.getQueryId());
    }

    private TemporaryTables() {
    }
}

