/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.List;

public final class ConnectorExpressions {
    private ConnectorExpressions() {
    }

    public static List<ConnectorExpression> extractConjuncts(ConnectorExpression expression) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        ConnectorExpressions.extractConjuncts(expression, (ImmutableList.Builder<ConnectorExpression>)resultBuilder);
        return resultBuilder.build();
    }

    private static void extractConjuncts(ConnectorExpression expression, ImmutableList.Builder<ConnectorExpression> resultBuilder) {
        Call call;
        if (expression instanceof Call && StandardFunctions.AND_FUNCTION_NAME.equals((Object)(call = (Call)expression).getFunctionName())) {
            for (ConnectorExpression argument : call.getArguments()) {
                ConnectorExpressions.extractConjuncts(argument, resultBuilder);
            }
            return;
        }
        resultBuilder.add((Object)expression);
    }

    public static ConnectorExpression and(ConnectorExpression ... expressions) {
        return ConnectorExpressions.and(Arrays.asList(expressions));
    }

    public static ConnectorExpression and(List<ConnectorExpression> expressions) {
        if (expressions.size() > 1) {
            return new Call((Type)BooleanType.BOOLEAN, StandardFunctions.AND_FUNCTION_NAME, expressions);
        }
        if (expressions.isEmpty()) {
            return Constant.TRUE;
        }
        return (ConnectorExpression)Iterables.getOnlyElement(expressions);
    }
}

