/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import io.trino.plugin.base.classloader.ClassLoaderSafeRecordSet;
import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ClassLoaderSafeConnectorRecordSetProvider
implements ConnectorRecordSetProvider {
    private final ConnectorRecordSetProvider delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeConnectorRecordSetProvider(@ForClassLoaderSafe ConnectorRecordSetProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeRecordSet classLoaderSafeRecordSet = new ClassLoaderSafeRecordSet(this.delegate.getRecordSet(transaction, session, split, table, columns), this.classLoader);
            return classLoaderSafeRecordSet;
        }
    }
}

