/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigBinder;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.base.security.AnyCatalogPermissionsRule;
import io.trino.plugin.base.security.AnyCatalogSchemaPermissionsRule;
import io.trino.plugin.base.security.CatalogAccessControlRule;
import io.trino.plugin.base.security.CatalogSchemaAccessControlRule;
import io.trino.plugin.base.security.CatalogSessionPropertyAccessControlRule;
import io.trino.plugin.base.security.CatalogTableAccessControlRule;
import io.trino.plugin.base.security.FileBasedAccessControlConfig;
import io.trino.plugin.base.security.FileBasedSystemAccessControlRules;
import io.trino.plugin.base.security.ForwardingSystemAccessControl;
import io.trino.plugin.base.security.ImpersonationRule;
import io.trino.plugin.base.security.PrincipalUserMatchRule;
import io.trino.plugin.base.security.QueryAccessRule;
import io.trino.plugin.base.security.SessionPropertyAccessControlRule;
import io.trino.plugin.base.security.SystemInformationRule;
import io.trino.plugin.base.security.TableAccessControlRule;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemAccessControlFactory;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class FileBasedSystemAccessControl
implements SystemAccessControl {
    private static final Logger log = Logger.get(FileBasedSystemAccessControl.class);
    public static final String NAME = "file";
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final List<CatalogAccessControlRule> catalogRules;
    private final Optional<List<QueryAccessRule>> queryAccessRules;
    private final Optional<List<ImpersonationRule>> impersonationRules;
    private final Optional<List<PrincipalUserMatchRule>> principalUserMatchRules;
    private final Optional<List<SystemInformationRule>> systemInformationRules;
    private final List<CatalogSchemaAccessControlRule> schemaRules;
    private final List<CatalogTableAccessControlRule> tableRules;
    private final List<SessionPropertyAccessControlRule> sessionPropertyRules;
    private final List<CatalogSessionPropertyAccessControlRule> catalogSessionPropertyRules;
    private final Set<AnyCatalogPermissionsRule> anyCatalogPermissionsRules;
    private final Set<AnyCatalogSchemaPermissionsRule> anyCatalogSchemaPermissionsRules;

    private FileBasedSystemAccessControl(List<CatalogAccessControlRule> catalogRules, Optional<List<QueryAccessRule>> queryAccessRules, Optional<List<ImpersonationRule>> impersonationRules, Optional<List<PrincipalUserMatchRule>> principalUserMatchRules, Optional<List<SystemInformationRule>> systemInformationRules, List<CatalogSchemaAccessControlRule> schemaRules, List<CatalogTableAccessControlRule> tableRules, List<SessionPropertyAccessControlRule> sessionPropertyRules, List<CatalogSessionPropertyAccessControlRule> catalogSessionPropertyRules) {
        this.catalogRules = catalogRules;
        this.queryAccessRules = queryAccessRules;
        this.impersonationRules = impersonationRules;
        this.principalUserMatchRules = principalUserMatchRules;
        this.systemInformationRules = systemInformationRules;
        this.schemaRules = schemaRules;
        this.tableRules = tableRules;
        this.sessionPropertyRules = sessionPropertyRules;
        this.catalogSessionPropertyRules = catalogSessionPropertyRules;
        ImmutableSet.Builder anyCatalogPermissionsRules = ImmutableSet.builder();
        schemaRules.stream().map(CatalogSchemaAccessControlRule::toAnyCatalogPermissionsRule).flatMap(Optional::stream).forEach(arg_0 -> ((ImmutableSet.Builder)anyCatalogPermissionsRules).add(arg_0));
        tableRules.stream().map(CatalogTableAccessControlRule::toAnyCatalogPermissionsRule).flatMap(Optional::stream).forEach(arg_0 -> ((ImmutableSet.Builder)anyCatalogPermissionsRules).add(arg_0));
        catalogSessionPropertyRules.stream().map(CatalogSessionPropertyAccessControlRule::toAnyCatalogPermissionsRule).flatMap(Optional::stream).forEach(arg_0 -> ((ImmutableSet.Builder)anyCatalogPermissionsRules).add(arg_0));
        this.anyCatalogPermissionsRules = anyCatalogPermissionsRules.build();
        ImmutableSet.Builder anyCatalogSchemaPermissionsRules = ImmutableSet.builder();
        schemaRules.stream().map(CatalogSchemaAccessControlRule::toAnyCatalogSchemaPermissionsRule).flatMap(Optional::stream).forEach(arg_0 -> ((ImmutableSet.Builder)anyCatalogSchemaPermissionsRules).add(arg_0));
        tableRules.stream().map(CatalogTableAccessControlRule::toAnyCatalogSchemaPermissionsRule).flatMap(Optional::stream).forEach(arg_0 -> ((ImmutableSet.Builder)anyCatalogSchemaPermissionsRules).add(arg_0));
        this.anyCatalogSchemaPermissionsRules = anyCatalogSchemaPermissionsRules.build();
    }

    public void checkCanImpersonateUser(SystemSecurityContext context, String userName) {
        Identity identity = context.getIdentity();
        if (this.impersonationRules.isEmpty()) {
            if (this.principalUserMatchRules.isEmpty()) {
                AccessDeniedException.denyImpersonateUser((String)identity.getUser(), (String)userName);
            }
            return;
        }
        for (ImpersonationRule rule : this.impersonationRules.get()) {
            Optional<Boolean> allowed = rule.match(identity.getUser(), identity.getEnabledRoles(), userName);
            if (!allowed.isPresent()) continue;
            if (allowed.get().booleanValue()) {
                return;
            }
            AccessDeniedException.denyImpersonateUser((String)identity.getUser(), (String)userName);
        }
        AccessDeniedException.denyImpersonateUser((String)identity.getUser(), (String)userName);
    }

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        Objects.requireNonNull(principal, "principal is null");
        Objects.requireNonNull(userName, "userName is null");
        if (this.principalUserMatchRules.isEmpty()) {
            return;
        }
        if (principal.isEmpty()) {
            AccessDeniedException.denySetUser(principal, (String)userName);
        }
        String principalName = principal.get().getName();
        for (PrincipalUserMatchRule rule : this.principalUserMatchRules.get()) {
            Optional<Boolean> allowed = rule.match(principalName, userName);
            if (!allowed.isPresent()) continue;
            if (allowed.get().booleanValue()) {
                return;
            }
            AccessDeniedException.denySetUser(principal, (String)userName);
        }
        AccessDeniedException.denySetUser(principal, (String)userName);
    }

    public void checkCanExecuteQuery(SystemSecurityContext context) {
        if (!this.canAccessQuery(context.getIdentity(), Optional.empty(), QueryAccessRule.AccessMode.EXECUTE)) {
            AccessDeniedException.denyViewQuery();
        }
    }

    public void checkCanViewQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        if (!this.canAccessQuery(context.getIdentity(), Optional.of(queryOwner), QueryAccessRule.AccessMode.VIEW)) {
            AccessDeniedException.denyViewQuery();
        }
    }

    public Set<String> filterViewQueryOwnedBy(SystemSecurityContext context, Set<String> queryOwners) {
        if (this.queryAccessRules.isEmpty()) {
            return queryOwners;
        }
        Identity identity = context.getIdentity();
        return (Set)queryOwners.stream().filter(owner -> this.canAccessQuery(identity, Optional.of(owner), QueryAccessRule.AccessMode.VIEW)).collect(ImmutableSet.toImmutableSet());
    }

    public void checkCanKillQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        if (!this.canAccessQuery(context.getIdentity(), Optional.of(queryOwner), QueryAccessRule.AccessMode.KILL)) {
            AccessDeniedException.denyViewQuery();
        }
    }

    private boolean canAccessQuery(Identity identity, Optional<String> queryOwner, QueryAccessRule.AccessMode requiredAccess) {
        if (this.queryAccessRules.isEmpty()) {
            return true;
        }
        for (QueryAccessRule rule : this.queryAccessRules.get()) {
            Optional<Set<QueryAccessRule.AccessMode>> accessMode = rule.match(identity.getUser(), identity.getEnabledRoles(), identity.getGroups(), queryOwner);
            if (!accessMode.isPresent()) continue;
            return accessMode.get().contains((Object)requiredAccess);
        }
        return false;
    }

    public void checkCanReadSystemInformation(SystemSecurityContext context) {
        if (!this.checkCanSystemInformation(context.getIdentity(), SystemInformationRule.AccessMode.READ)) {
            AccessDeniedException.denyReadSystemInformationAccess();
        }
    }

    public void checkCanWriteSystemInformation(SystemSecurityContext context) {
        if (!this.checkCanSystemInformation(context.getIdentity(), SystemInformationRule.AccessMode.WRITE)) {
            AccessDeniedException.denyWriteSystemInformationAccess();
        }
    }

    private boolean checkCanSystemInformation(Identity identity, SystemInformationRule.AccessMode requiredAccess) {
        for (SystemInformationRule rule : this.systemInformationRules.orElseGet(ImmutableList::of)) {
            Optional<Set<SystemInformationRule.AccessMode>> accessMode = rule.match(identity.getUser(), identity.getEnabledRoles());
            if (!accessMode.isPresent()) continue;
            return accessMode.get().contains((Object)requiredAccess);
        }
        return false;
    }

    public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
        Identity identity = context.getIdentity();
        boolean allowed = this.sessionPropertyRules.stream().map(rule -> rule.match(identity.getUser(), identity.getEnabledRoles(), identity.getGroups(), propertyName)).flatMap(Optional::stream).findFirst().orElse(false);
        if (!allowed) {
            AccessDeniedException.denySetSystemSessionProperty((String)propertyName);
        }
    }

    public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
        if (!this.canAccessCatalog(context, catalogName, CatalogAccessControlRule.AccessMode.READ_ONLY)) {
            AccessDeniedException.denyCatalogAccess((String)catalogName);
        }
    }

    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        ImmutableSet.Builder filteredCatalogs = ImmutableSet.builder();
        for (String catalog : catalogs) {
            if (!this.checkAnyCatalogAccess(context, catalog)) continue;
            filteredCatalogs.add((Object)catalog);
        }
        return filteredCatalogs.build();
    }

    public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.isSchemaOwner(context, schema)) {
            AccessDeniedException.denyCreateSchema((String)schema.toString());
        }
    }

    public void checkCanDropSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.isSchemaOwner(context, schema)) {
            AccessDeniedException.denyDropSchema((String)schema.toString());
        }
    }

    public void checkCanRenameSchema(SystemSecurityContext context, CatalogSchemaName schema, String newSchemaName) {
        if (!this.isSchemaOwner(context, schema) || !this.isSchemaOwner(context, new CatalogSchemaName(schema.getCatalogName(), newSchemaName))) {
            AccessDeniedException.denyRenameSchema((String)schema.toString(), (String)newSchemaName);
        }
    }

    public void checkCanSetSchemaAuthorization(SystemSecurityContext context, CatalogSchemaName schema, TrinoPrincipal principal) {
        if (!this.isSchemaOwner(context, schema)) {
            AccessDeniedException.denySetSchemaAuthorization((String)schema.toString(), (TrinoPrincipal)principal);
        }
    }

    public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
        if (!this.checkAnyCatalogAccess(context, catalogName)) {
            AccessDeniedException.denyShowSchemas();
        }
    }

    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        return (Set)schemaNames.stream().filter(schemaName -> this.checkAnySchemaAccess(context, catalogName, (String)schemaName)).collect(ImmutableSet.toImmutableSet());
    }

    public void checkCanShowCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyShowCreateTable((String)table.toString());
        }
    }

    public void checkCanShowCreateSchema(SystemSecurityContext context, CatalogSchemaName schemaName) {
        if (!this.isSchemaOwner(context, schemaName)) {
            AccessDeniedException.denyShowCreateSchema((String)schemaName.toString());
        }
    }

    public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Object> properties) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyCreateTable((String)table.toString());
        }
    }

    public void checkCanDropTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropTable((String)table.toString());
        }
    }

    public void checkCanTruncateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.DELETE)) {
            AccessDeniedException.denyTruncateTable((String)table.toString());
        }
    }

    public void checkCanRenameTable(SystemSecurityContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.OWNERSHIP) || !this.checkTablePermission(context, newTable, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameTable((String)table.toString(), (String)newTable.toString());
        }
    }

    public void checkCanSetTableProperties(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Optional<Object>> properties) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denySetTableProperties((String)table.toString());
        }
    }

    public void checkCanSetTableComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyCommentTable((String)table.toString());
        }
    }

    public void checkCanSetColumnComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyCommentColumn((String)table.toString());
        }
    }

    public void checkCanShowTables(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.checkAnySchemaAccess(context, schema.getCatalogName(), schema.getSchemaName())) {
            AccessDeniedException.denyShowTables((String)schema.toString());
        }
    }

    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return (Set)tableNames.stream().filter(tableName -> this.isSchemaOwner(context, new CatalogSchemaName(catalogName, tableName.getSchemaName())) || this.checkAnyTablePermission(context, new CatalogSchemaTableName(catalogName, tableName))).collect(ImmutableSet.toImmutableSet());
    }

    public void checkCanShowColumns(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.checkAnyTablePermission(context, table)) {
            AccessDeniedException.denyShowColumns((String)table.toString());
        }
    }

    public Set<String> filterColumns(SystemSecurityContext context, CatalogSchemaTableName tableName, Set<String> columns) {
        if (!this.checkAnyTablePermission(context, tableName)) {
            return ImmutableSet.of();
        }
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaTableName().getSchemaName())) {
            return columns;
        }
        Identity identity = context.getIdentity();
        CatalogTableAccessControlRule rule = this.tableRules.stream().filter(tableRule -> tableRule.matches(identity.getUser(), identity.getEnabledRoles(), identity.getGroups(), tableName)).findFirst().orElse(null);
        if (rule == null || rule.getPrivileges().isEmpty()) {
            return ImmutableSet.of();
        }
        if (rule.getPrivileges().stream().anyMatch(privilege -> TableAccessControlRule.TablePrivilege.SELECT != privilege && TableAccessControlRule.TablePrivilege.GRANT_SELECT != privilege)) {
            return columns;
        }
        Set<String> restrictedColumns = rule.getRestrictedColumns();
        return (Set)columns.stream().filter(column -> !restrictedColumns.contains(column)).collect(ImmutableSet.toImmutableSet());
    }

    public void checkCanAddColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyAddColumn((String)table.toString());
        }
    }

    public void checkCanDropColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropColumn((String)table.toString());
        }
    }

    public void checkCanRenameColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameColumn((String)table.toString());
        }
    }

    public void checkCanSetTableAuthorization(SystemSecurityContext context, CatalogSchemaTableName table, TrinoPrincipal principal) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denySetTableAuthorization((String)table.toString(), (TrinoPrincipal)principal);
        }
    }

    public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        if (!this.canAccessCatalog(context, table.getCatalogName(), CatalogAccessControlRule.AccessMode.READ_ONLY)) {
            AccessDeniedException.denySelectTable((String)table.toString());
        }
        if (INFORMATION_SCHEMA_NAME.equals(table.getSchemaTableName().getSchemaName())) {
            return;
        }
        Identity identity = context.getIdentity();
        boolean allowed = this.tableRules.stream().filter(rule -> rule.matches(identity.getUser(), identity.getEnabledRoles(), identity.getGroups(), table)).map(rule -> rule.canSelectColumns(columns)).findFirst().orElse(false);
        if (!allowed) {
            AccessDeniedException.denySelectTable((String)table.toString());
        }
    }

    public void checkCanInsertIntoTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.INSERT)) {
            AccessDeniedException.denyInsertTable((String)table.toString());
        }
    }

    public void checkCanDeleteFromTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.DELETE)) {
            AccessDeniedException.denyDeleteTable((String)table.toString());
        }
    }

    public void checkCanUpdateTableColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> updatedColumnNames) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.UPDATE)) {
            AccessDeniedException.denyUpdateTableColumns((String)table.toString(), updatedColumnNames);
        }
    }

    public void checkCanCreateView(SystemSecurityContext context, CatalogSchemaTableName view) {
        if (!this.checkTablePermission(context, view, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyCreateView((String)view.toString());
        }
    }

    public void checkCanRenameView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        if (!this.checkTablePermission(context, view, TableAccessControlRule.TablePrivilege.OWNERSHIP) || !this.checkTablePermission(context, newView, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameView((String)view.toString(), (String)newView.toString());
        }
    }

    public void checkCanSetViewAuthorization(SystemSecurityContext context, CatalogSchemaTableName view, TrinoPrincipal principal) {
        if (!this.checkTablePermission(context, view, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denySetViewAuthorization((String)view.toString(), (TrinoPrincipal)principal);
        }
    }

    public void checkCanDropView(SystemSecurityContext context, CatalogSchemaTableName view) {
        if (!this.checkTablePermission(context, view, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropView((String)view.toString());
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        if (!this.canAccessCatalog(context, table.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denySelectTable((String)table.toString());
        }
        if (INFORMATION_SCHEMA_NAME.equals(table.getSchemaTableName().getSchemaName())) {
            return;
        }
        Identity identity = context.getIdentity();
        CatalogTableAccessControlRule rule = this.tableRules.stream().filter(tableRule -> tableRule.matches(identity.getUser(), identity.getEnabledRoles(), identity.getGroups(), table)).findFirst().orElse(null);
        if (rule == null || !rule.canSelectColumns(columns)) {
            AccessDeniedException.denySelectTable((String)table.toString());
        }
        if (!rule.getPrivileges().contains((Object)TableAccessControlRule.TablePrivilege.GRANT_SELECT)) {
            AccessDeniedException.denyCreateViewWithSelect((String)table.toString(), (Identity)context.getIdentity());
        }
    }

    public void checkCanCreateMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Object> properties) {
        if (!this.checkTablePermission(context, materializedView, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyCreateMaterializedView((String)materializedView.toString());
        }
    }

    public void checkCanRefreshMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView) {
        if (!this.checkTablePermission(context, materializedView, TableAccessControlRule.TablePrivilege.UPDATE)) {
            AccessDeniedException.denyRefreshMaterializedView((String)materializedView.toString());
        }
    }

    public void checkCanDropMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView) {
        if (!this.checkTablePermission(context, materializedView, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDropMaterializedView((String)materializedView.toString());
        }
    }

    public void checkCanRenameMaterializedView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        if (!this.checkTablePermission(context, view, TableAccessControlRule.TablePrivilege.OWNERSHIP) || !this.checkTablePermission(context, newView, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRenameMaterializedView((String)view.toString(), (String)newView.toString());
        }
    }

    public void checkCanSetMaterializedViewProperties(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Optional<Object>> properties) {
        if (!this.checkTablePermission(context, materializedView, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denySetMaterializedViewProperties((String)materializedView.toString());
        }
    }

    public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, String functionName, TrinoPrincipal grantee, boolean grantOption) {
    }

    public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
        boolean allowed;
        Identity identity = context.getIdentity();
        boolean bl = allowed = this.canAccessCatalog(context, catalogName, CatalogAccessControlRule.AccessMode.READ_ONLY) && this.catalogSessionPropertyRules.stream().map(rule -> rule.match(identity.getUser(), identity.getEnabledRoles(), identity.getGroups(), catalogName, propertyName)).flatMap(Optional::stream).findFirst().orElse(false) != false;
        if (!allowed) {
            AccessDeniedException.denySetCatalogSessionProperty((String)propertyName);
        }
    }

    public void checkCanGrantSchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal grantee, boolean grantOption) {
        if (!this.canAccessCatalog(context, schema.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyGrantSchemaPrivilege((String)privilege.name(), (String)schema.toString());
        }
        if (!this.isSchemaOwner(context, schema)) {
            AccessDeniedException.denyGrantSchemaPrivilege((String)privilege.name(), (String)schema.toString());
        }
    }

    public void checkCanDenySchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal grantee) {
        if (!this.canAccessCatalog(context, schema.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyDenySchemaPrivilege((String)privilege.name(), (String)schema.toString());
        }
        if (!this.isSchemaOwner(context, schema)) {
            AccessDeniedException.denyDenySchemaPrivilege((String)privilege.name(), (String)schema.toString());
        }
    }

    public void checkCanRevokeSchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal revokee, boolean grantOption) {
        if (!this.canAccessCatalog(context, schema.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            AccessDeniedException.denyRevokeSchemaPrivilege((String)privilege.name(), (String)schema.toString());
        }
        if (!this.isSchemaOwner(context, schema)) {
            AccessDeniedException.denyRevokeSchemaPrivilege((String)privilege.name(), (String)schema.toString());
        }
    }

    public void checkCanGrantTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal grantee, boolean grantOption) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)table.toString());
        }
    }

    public void checkCanDenyTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal grantee) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyDenyTablePrivilege((String)privilege.name(), (String)table.toString());
        }
    }

    public void checkCanRevokeTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal revokee, boolean grantOption) {
        if (!this.checkTablePermission(context, table, TableAccessControlRule.TablePrivilege.OWNERSHIP)) {
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)table.toString());
        }
    }

    public void checkCanCreateRole(SystemSecurityContext context, String role, Optional<TrinoPrincipal> grantor) {
        AccessDeniedException.denyCreateRole((String)role);
    }

    public void checkCanDropRole(SystemSecurityContext context, String role) {
        AccessDeniedException.denyDropRole((String)role);
    }

    public void checkCanGrantRoles(SystemSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        AccessDeniedException.denyGrantRoles(roles, grantees);
    }

    public void checkCanRevokeRoles(SystemSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        AccessDeniedException.denyRevokeRoles(roles, grantees);
    }

    public void checkCanShowRoleAuthorizationDescriptors(SystemSecurityContext context) {
        AccessDeniedException.denyShowRoleAuthorizationDescriptors();
    }

    public void checkCanShowCurrentRoles(SystemSecurityContext context) {
    }

    public void checkCanShowRoleGrants(SystemSecurityContext context) {
    }

    public void checkCanShowRoles(SystemSecurityContext context) {
    }

    public void checkCanExecuteProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName procedure) {
    }

    public void checkCanExecuteFunction(SystemSecurityContext systemSecurityContext, String functionName) {
    }

    public void checkCanExecuteTableProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaTableName table, String procedure) {
    }

    public Iterable<EventListener> getEventListeners() {
        return ImmutableSet.of();
    }

    public List<ViewExpression> getRowFilters(SystemSecurityContext context, CatalogSchemaTableName table) {
        SchemaTableName tableName = table.getSchemaTableName();
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return ImmutableList.of();
        }
        Identity identity = context.getIdentity();
        return (List)this.tableRules.stream().filter(rule -> rule.matches(identity.getUser(), identity.getEnabledRoles(), identity.getGroups(), table)).map(rule -> rule.getFilter(identity.getUser(), table.getCatalogName(), tableName.getSchemaName())).flatMap(Optional::stream).limit(1L).collect(ImmutableList.toImmutableList());
    }

    public List<ViewExpression> getColumnMasks(SystemSecurityContext context, CatalogSchemaTableName table, String columnName, Type type) {
        SchemaTableName tableName = table.getSchemaTableName();
        if (INFORMATION_SCHEMA_NAME.equals(tableName.getSchemaName())) {
            return ImmutableList.of();
        }
        Identity identity = context.getIdentity();
        return (List)this.tableRules.stream().filter(rule -> rule.matches(identity.getUser(), identity.getEnabledRoles(), identity.getGroups(), table)).map(rule -> rule.getColumnMask(identity.getUser(), table.getCatalogName(), table.getSchemaTableName().getSchemaName(), columnName)).flatMap(Optional::stream).limit(1L).collect(ImmutableList.toImmutableList());
    }

    private boolean checkAnyCatalogAccess(SystemSecurityContext context, String catalogName) {
        Identity identity = context.getIdentity();
        return this.canAccessCatalog(context, catalogName, CatalogAccessControlRule.AccessMode.READ_ONLY) && this.anyCatalogPermissionsRules.stream().anyMatch(rule -> rule.match(identity.getUser(), identity.getEnabledRoles(), identity.getGroups(), catalogName));
    }

    private boolean canAccessCatalog(SystemSecurityContext context, String catalogName, CatalogAccessControlRule.AccessMode requiredAccess) {
        Identity identity = context.getIdentity();
        for (CatalogAccessControlRule rule : this.catalogRules) {
            Optional<CatalogAccessControlRule.AccessMode> accessMode = rule.match(identity.getUser(), identity.getEnabledRoles(), identity.getGroups(), catalogName);
            if (!accessMode.isPresent()) continue;
            return accessMode.get().implies(requiredAccess);
        }
        return false;
    }

    private boolean checkAnySchemaAccess(SystemSecurityContext context, String catalogName, String schemaName) {
        Identity identity = context.getIdentity();
        return this.canAccessCatalog(context, catalogName, CatalogAccessControlRule.AccessMode.READ_ONLY) && this.anyCatalogSchemaPermissionsRules.stream().anyMatch(rule -> rule.match(identity.getUser(), identity.getEnabledRoles(), identity.getGroups(), catalogName, schemaName));
    }

    private boolean isSchemaOwner(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.canAccessCatalog(context, schema.getCatalogName(), CatalogAccessControlRule.AccessMode.ALL)) {
            return false;
        }
        Identity identity = context.getIdentity();
        for (CatalogSchemaAccessControlRule rule : this.schemaRules) {
            Optional<Boolean> owner = rule.match(identity.getUser(), identity.getEnabledRoles(), identity.getGroups(), schema);
            if (!owner.isPresent()) continue;
            return owner.get();
        }
        return false;
    }

    private boolean checkAnyTablePermission(SystemSecurityContext context, CatalogSchemaTableName table) {
        return this.checkTablePermission(context, table, CatalogAccessControlRule.AccessMode.READ_ONLY, privileges -> !privileges.isEmpty());
    }

    private boolean checkTablePermission(SystemSecurityContext context, CatalogSchemaTableName table, TableAccessControlRule.TablePrivilege requiredPrivilege) {
        CatalogAccessControlRule.AccessMode requiredCatalogAccess = requiredPrivilege == TableAccessControlRule.TablePrivilege.SELECT || requiredPrivilege == TableAccessControlRule.TablePrivilege.GRANT_SELECT ? CatalogAccessControlRule.AccessMode.READ_ONLY : CatalogAccessControlRule.AccessMode.ALL;
        return this.checkTablePermission(context, table, requiredCatalogAccess, privileges -> privileges.contains((Object)requiredPrivilege));
    }

    private boolean checkTablePermission(SystemSecurityContext context, CatalogSchemaTableName table, CatalogAccessControlRule.AccessMode requiredCatalogAccess, Predicate<Set<TableAccessControlRule.TablePrivilege>> checkPrivileges) {
        if (!this.canAccessCatalog(context, table.getCatalogName(), requiredCatalogAccess)) {
            return false;
        }
        if (INFORMATION_SCHEMA_NAME.equals(table.getSchemaTableName().getSchemaName())) {
            return true;
        }
        Identity identity = context.getIdentity();
        for (CatalogTableAccessControlRule rule : this.tableRules) {
            if (!rule.matches(identity.getUser(), identity.getEnabledRoles(), identity.getGroups(), table)) continue;
            return checkPrivileges.test(rule.getPrivileges());
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<CatalogAccessControlRule> catalogRules = ImmutableList.of((Object)CatalogAccessControlRule.ALLOW_ALL);
        private Optional<List<QueryAccessRule>> queryAccessRules = Optional.empty();
        private Optional<List<ImpersonationRule>> impersonationRules = Optional.empty();
        private Optional<List<PrincipalUserMatchRule>> principalUserMatchRules = Optional.empty();
        private Optional<List<SystemInformationRule>> systemInformationRules = Optional.empty();
        private List<CatalogSchemaAccessControlRule> schemaRules = ImmutableList.of((Object)CatalogSchemaAccessControlRule.ALLOW_ALL);
        private List<CatalogTableAccessControlRule> tableRules = ImmutableList.of((Object)CatalogTableAccessControlRule.ALLOW_ALL);
        private List<SessionPropertyAccessControlRule> sessionPropertyRules = ImmutableList.of((Object)SessionPropertyAccessControlRule.ALLOW_ALL);
        private List<CatalogSessionPropertyAccessControlRule> catalogSessionPropertyRules = ImmutableList.of((Object)CatalogSessionPropertyAccessControlRule.ALLOW_ALL);

        public Builder denyAllAccess() {
            this.catalogRules = ImmutableList.of();
            this.queryAccessRules = Optional.of(ImmutableList.of());
            this.impersonationRules = Optional.of(ImmutableList.of());
            this.principalUserMatchRules = Optional.of(ImmutableList.of());
            this.systemInformationRules = Optional.of(ImmutableList.of());
            this.schemaRules = ImmutableList.of();
            this.tableRules = ImmutableList.of();
            this.sessionPropertyRules = ImmutableList.of();
            this.catalogSessionPropertyRules = ImmutableList.of();
            return this;
        }

        public Builder setCatalogRules(List<CatalogAccessControlRule> catalogRules) {
            this.catalogRules = catalogRules;
            return this;
        }

        public Builder setQueryAccessRules(Optional<List<QueryAccessRule>> queryAccessRules) {
            this.queryAccessRules = queryAccessRules;
            return this;
        }

        public Builder setImpersonationRules(Optional<List<ImpersonationRule>> impersonationRules) {
            this.impersonationRules = impersonationRules;
            return this;
        }

        public Builder setPrincipalUserMatchRules(Optional<List<PrincipalUserMatchRule>> principalUserMatchRules) {
            this.principalUserMatchRules = principalUserMatchRules;
            return this;
        }

        public Builder setSystemInformationRules(Optional<List<SystemInformationRule>> systemInformationRules) {
            this.systemInformationRules = systemInformationRules;
            return this;
        }

        public Builder setSchemaRules(List<CatalogSchemaAccessControlRule> schemaRules) {
            this.schemaRules = schemaRules;
            return this;
        }

        public Builder setTableRules(List<CatalogTableAccessControlRule> tableRules) {
            this.tableRules = tableRules;
            return this;
        }

        public Builder setSessionPropertyRules(List<SessionPropertyAccessControlRule> sessionPropertyRules) {
            this.sessionPropertyRules = sessionPropertyRules;
            return this;
        }

        public Builder setCatalogSessionPropertyRules(List<CatalogSessionPropertyAccessControlRule> catalogSessionPropertyRules) {
            this.catalogSessionPropertyRules = catalogSessionPropertyRules;
            return this;
        }

        public FileBasedSystemAccessControl build() {
            return new FileBasedSystemAccessControl(this.catalogRules, this.queryAccessRules, this.impersonationRules, this.principalUserMatchRules, this.systemInformationRules, this.schemaRules, this.tableRules, this.sessionPropertyRules, this.catalogSessionPropertyRules);
        }
    }

    public static class Factory
    implements SystemAccessControlFactory {
        public String getName() {
            return FileBasedSystemAccessControl.NAME;
        }

        public SystemAccessControl create(Map<String, String> config) {
            Objects.requireNonNull(config, "config is null");
            Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(FileBasedAccessControlConfig.class)});
            Injector injector = bootstrap.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            FileBasedAccessControlConfig fileBasedAccessControlConfig = (FileBasedAccessControlConfig)injector.getInstance(FileBasedAccessControlConfig.class);
            String configFileName = fileBasedAccessControlConfig.getConfigFile().getPath();
            if (config.containsKey("security.refresh-period")) {
                Duration refreshPeriod;
                try {
                    refreshPeriod = fileBasedAccessControlConfig.getRefreshPeriod();
                }
                catch (IllegalArgumentException e) {
                    throw Factory.invalidRefreshPeriodException(config, configFileName);
                }
                if (refreshPeriod.toMillis() == 0L) {
                    throw Factory.invalidRefreshPeriodException(config, configFileName);
                }
                return ForwardingSystemAccessControl.of((Supplier<SystemAccessControl>)Suppliers.memoizeWithExpiration(() -> {
                    log.info("Refreshing system access control from %s", new Object[]{configFileName});
                    return Factory.create(configFileName);
                }, (long)refreshPeriod.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
            }
            return Factory.create(configFileName);
        }

        private static TrinoException invalidRefreshPeriodException(Map<String, String> config, String configFileName) {
            return new TrinoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, String.format("Invalid duration value '%s' for property '%s' in '%s'", config.get("security.refresh-period"), "security.refresh-period", configFileName));
        }

        private static SystemAccessControl create(String configFileName) {
            ImmutableList catalogAccessControlRules;
            FileBasedSystemAccessControlRules rules = JsonUtils.parseJson(Paths.get(configFileName, new String[0]), FileBasedSystemAccessControlRules.class);
            if (rules.getCatalogRules().isPresent()) {
                ImmutableList.Builder catalogRulesBuilder = ImmutableList.builder();
                catalogRulesBuilder.addAll((Iterable)rules.getCatalogRules().get());
                catalogRulesBuilder.add((Object)new CatalogAccessControlRule(CatalogAccessControlRule.AccessMode.ALL, Optional.of(Pattern.compile(".*")), Optional.empty(), Optional.empty(), Optional.of(Pattern.compile("system"))));
                catalogAccessControlRules = catalogRulesBuilder.build();
            } else {
                catalogAccessControlRules = ImmutableList.of((Object)CatalogAccessControlRule.ALLOW_ALL);
            }
            return FileBasedSystemAccessControl.builder().setCatalogRules((List<CatalogAccessControlRule>)catalogAccessControlRules).setQueryAccessRules(rules.getQueryAccessRules()).setImpersonationRules(rules.getImpersonationRules()).setPrincipalUserMatchRules(rules.getPrincipalUserMatchRules()).setSystemInformationRules(rules.getSystemInformationRules()).setSchemaRules(rules.getSchemaRules().orElse((List<CatalogSchemaAccessControlRule>)ImmutableList.of((Object)CatalogSchemaAccessControlRule.ALLOW_ALL))).setTableRules(rules.getTableRules().orElse((List<CatalogTableAccessControlRule>)ImmutableList.of((Object)CatalogTableAccessControlRule.ALLOW_ALL))).setSessionPropertyRules(rules.getSessionPropertyRules().orElse((List<SessionPropertyAccessControlRule>)ImmutableList.of((Object)SessionPropertyAccessControlRule.ALLOW_ALL))).setCatalogSessionPropertyRules(rules.getCatalogSessionPropertyRules().orElse((List<CatalogSessionPropertyAccessControlRule>)ImmutableList.of((Object)CatalogSessionPropertyAccessControlRule.ALLOW_ALL))).build();
        }
    }
}

