/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.trino.plugin.base.cache.NonEvictableCache;
import io.trino.plugin.base.cache.NonEvictableCacheImpl;
import io.trino.plugin.base.cache.NonEvictableLoadingCache;
import io.trino.plugin.base.cache.NonEvictableLoadingCacheImpl;
import io.trino.plugin.base.cache.NonKeyEvictableCache;
import io.trino.plugin.base.cache.NonKeyEvictableCacheImpl;
import io.trino.plugin.base.cache.NonKeyEvictableLoadingCache;
import io.trino.plugin.base.cache.NonKeyEvictableLoadingCacheImpl;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public final class SafeCaches {
    private SafeCaches() {
    }

    public static <K, V> NonEvictableCache<K, V> buildNonEvictableCache(CacheBuilder<? super K, ? super V> cacheBuilder) {
        return new NonEvictableCacheImpl<K, V>(SafeCaches.buildUnsafeCache(cacheBuilder));
    }

    public static <K, V> NonKeyEvictableCache<K, V> buildNonEvictableCacheWithWeakInvalidateAll(CacheBuilder<? super K, ? super V> cacheBuilder) {
        return new NonKeyEvictableCacheImpl<K, V>(SafeCaches.buildUnsafeCache(cacheBuilder));
    }

    public static <K, V> NonEvictableLoadingCache<K, V> buildNonEvictableCache(CacheBuilder<? super K, ? super V> cacheBuilder, CacheLoader<? super K, V> cacheLoader) {
        return new NonEvictableLoadingCacheImpl<K, V>(SafeCaches.buildUnsafeCache(cacheBuilder, cacheLoader));
    }

    public static <K, V> NonKeyEvictableLoadingCache<K, V> buildNonEvictableCacheWithWeakInvalidateAll(CacheBuilder<? super K, ? super V> cacheBuilder, CacheLoader<? super K, V> cacheLoader) {
        return new NonKeyEvictableLoadingCacheImpl<K, V>(SafeCaches.buildUnsafeCache(cacheBuilder, cacheLoader));
    }

    @SuppressModernizer
    private static <K, V> Cache<K, V> buildUnsafeCache(CacheBuilder<? super K, ? super V> cacheBuilder) {
        return cacheBuilder.build();
    }

    @SuppressModernizer
    private static <K, V> LoadingCache<K, V> buildUnsafeCache(CacheBuilder<? super K, ? super V> cacheBuilder, CacheLoader<? super K, V> cacheLoader) {
        return cacheBuilder.build(cacheLoader);
    }
}

