/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.plugin.base.security.AnySchemaPermissionsRule;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class SchemaAccessControlRule {
    public static final SchemaAccessControlRule ALLOW_ALL = new SchemaAccessControlRule(true, Optional.empty(), Optional.empty(), Optional.empty());
    private final boolean owner;
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> groupRegex;
    private final Optional<Pattern> schemaRegex;

    @JsonCreator
    public SchemaAccessControlRule(@JsonProperty(value="owner") boolean owner, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="group") Optional<Pattern> groupRegex, @JsonProperty(value="schema") Optional<Pattern> schemaRegex) {
        this.owner = owner;
        this.userRegex = Objects.requireNonNull(userRegex, "user is null");
        this.groupRegex = Objects.requireNonNull(groupRegex, "group is null");
        this.schemaRegex = Objects.requireNonNull(schemaRegex, "sourceRegex is null");
    }

    public Optional<Boolean> match(String user, Set<String> groups, String schema) {
        if (this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true).booleanValue() && this.groupRegex.map(regex -> groups.stream().anyMatch(group -> regex.matcher((CharSequence)group).matches())).orElse(true).booleanValue() && this.schemaRegex.map(regex -> regex.matcher(schema).matches()).orElse(true).booleanValue()) {
            return Optional.of(this.owner);
        }
        return Optional.empty();
    }

    Optional<AnySchemaPermissionsRule> toAnySchemaPermissionsRule() {
        if (!this.owner) {
            return Optional.empty();
        }
        return Optional.of(new AnySchemaPermissionsRule(this.userRegex, this.groupRegex, this.schemaRegex));
    }

    boolean isOwner() {
        return this.owner;
    }

    Optional<Pattern> getUserRegex() {
        return this.userRegex;
    }

    Optional<Pattern> getGroupRegex() {
        return this.groupRegex;
    }

    Optional<Pattern> getSchemaRegex() {
        return this.schemaRegex;
    }
}

