/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class AnyCatalogSchemaPermissionsRule {
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> groupRegex;
    private final Optional<Pattern> catalogRegex;
    private final Optional<Pattern> schemaRegex;

    public AnyCatalogSchemaPermissionsRule(Optional<Pattern> userRegex, Optional<Pattern> groupRegex, Optional<Pattern> catalogRegex, Optional<Pattern> schemaRegex) {
        this.userRegex = userRegex;
        this.groupRegex = groupRegex;
        this.catalogRegex = catalogRegex;
        this.schemaRegex = schemaRegex;
    }

    public boolean match(String user, Set<String> groups, String catalogName, String schemaName) {
        return this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true) != false && this.groupRegex.map(regex -> groups.stream().anyMatch(group -> regex.matcher((CharSequence)group).matches())).orElse(true) != false && this.catalogRegex.map(regex -> regex.matcher(catalogName).matches()).orElse(true) != false && this.schemaRegex.map(regex -> regex.matcher(schemaName).matches()).orElse(true) != false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnyCatalogSchemaPermissionsRule that = (AnyCatalogSchemaPermissionsRule)o;
        return AnyCatalogSchemaPermissionsRule.patternEquals(this.userRegex, that.userRegex) && AnyCatalogSchemaPermissionsRule.patternEquals(this.groupRegex, that.groupRegex) && AnyCatalogSchemaPermissionsRule.patternEquals(this.catalogRegex, that.catalogRegex) && AnyCatalogSchemaPermissionsRule.patternEquals(this.schemaRegex, that.schemaRegex);
    }

    private static boolean patternEquals(Optional<Pattern> left, Optional<Pattern> right) {
        if (left.isEmpty() || right.isEmpty()) {
            return left.isEmpty() == right.isEmpty();
        }
        Pattern leftPattern = left.get();
        Pattern rightPattern = right.get();
        return leftPattern.pattern().equals(rightPattern.pattern()) && leftPattern.flags() == rightPattern.flags();
    }

    public int hashCode() {
        return Objects.hash(this.userRegex, this.groupRegex, this.catalogRegex, this.schemaRegex);
    }
}

