/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import io.airlift.log.Logger;
import io.trino.server.ModuleReader;
import io.trino.server.PluginLoader;
import io.trino.spi.Plugin;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import picocli.CommandLine;

@CommandLine.Command(name="modulesToConnectors", mixinStandardHelpOptions=true, description={"Maps Trino plugin modules to connectors they provide and filters them using an impacted modules list."})
public class PluginReader
implements Callable<Integer> {
    private static final Logger log = Logger.get(PluginReader.class);
    @CommandLine.Option(names={"-i", "--impacted-modules"}, description={"Impacted modules file generated by the gitflow-incremental-builder (GIB) Maven plugin"})
    private Optional<File> impactedModulesFile;
    @CommandLine.Option(names={"-p", "--plugin-dir"}, description={"Trino plugin directory"})
    private File pluginDir = new File("plugin");
    @CommandLine.Option(names={"-r", "--root-pom"}, description={"Trino root module pom.xml"})
    private File rootPom = new File("pom.xml");

    public static void main(String ... args) {
        int exitCode = new CommandLine((Object)new PluginReader()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() {
        Optional<Object> impactedModules = Optional.empty();
        if (this.impactedModulesFile.isPresent() && (impactedModules = PluginReader.readImpactedModules(this.impactedModulesFile.get())).isEmpty()) {
            return 1;
        }
        Map<String, String> modulesToPlugins = ModuleReader.mapModulesToPlugins(this.rootPom);
        Stream<Object> modulesStream = modulesToPlugins.entrySet().stream();
        if (impactedModules.isPresent()) {
            List<String> nonPluginModules = ((List)impactedModules.get()).stream().filter(Predicate.not(modulesToPlugins::containsKey)).toList();
            if (!nonPluginModules.isEmpty()) {
                log.warn("Impacted modules list includes non-plugin modules, ignoring it: %s", new Object[]{nonPluginModules});
            } else {
                List finalImpactedModules = (List)impactedModules.get();
                modulesStream = modulesStream.filter(entry -> finalImpactedModules.contains(entry.getKey()));
            }
        }
        Map plugins = PluginLoader.loadPlugins(this.pluginDir).stream().collect(Collectors.toMap(plugin -> plugin.getClass().getName(), Function.identity()));
        modulesStream.forEach(entry -> {
            if (!plugins.containsKey(entry.getValue())) {
                log.warn("Plugin without any connectors: %s", new Object[]{entry.getValue()});
                return;
            }
            PluginLoader.printPluginFeatures((Plugin)plugins.get(entry.getValue()));
        });
        return 0;
    }

    private static Optional<List<String>> readImpactedModules(File gibImpactedModules) {
        try {
            return Optional.of(Files.readAllLines(gibImpactedModules.toPath()));
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Couldn't read file %s", new Object[]{gibImpactedModules});
            return Optional.empty();
        }
    }
}

