/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.password.ldap;

import com.google.common.collect.ImmutableSet;
import io.trino.plugin.base.ldap.LdapClient;
import io.trino.plugin.base.ldap.LdapQuery;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;

public class LdapAuthenticatorClient {
    private final LdapClient ldapClient;

    @Inject
    public LdapAuthenticatorClient(LdapClient ldapClient) {
        this.ldapClient = Objects.requireNonNull(ldapClient, "ldapClient is null");
    }

    public void validatePassword(String userDistinguishedName, String password) throws NamingException {
        this.ldapClient.processLdapContext(userDistinguishedName, password, context -> null);
    }

    public boolean isGroupMember(String searchBase, String groupSearch, String contextUserDistinguishedName, String contextPassword) throws NamingException {
        return (Boolean)this.ldapClient.executeLdapQuery(contextUserDistinguishedName, contextPassword, new LdapQuery.LdapQueryBuilder().withSearchBase(searchBase).withSearchFilter(groupSearch).build(), NamingEnumeration::hasMore);
    }

    public Set<String> lookupUserDistinguishedNames(String searchBase, String searchFilter, String contextUserDistinguishedName, String contextPassword) throws NamingException {
        return (Set)this.ldapClient.executeLdapQuery(contextUserDistinguishedName, contextPassword, new LdapQuery.LdapQueryBuilder().withSearchBase(searchBase).withSearchFilter(searchFilter).build(), searchResults -> {
            ImmutableSet.Builder distinguishedNames = ImmutableSet.builder();
            while (searchResults.hasMore()) {
                distinguishedNames.add((Object)((SearchResult)searchResults.next()).getNameInNamespace());
            }
            return distinguishedNames.build();
        });
    }
}

