/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.password.ldap;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.airlift.security.pem.PemReader;
import io.airlift.units.Duration;
import io.trino.plugin.password.jndi.JndiUtils;
import io.trino.plugin.password.ldap.LdapAuthenticatorClient;
import io.trino.plugin.password.ldap.LdapConfig;
import io.trino.plugin.password.ldap.LdapSslSocketFactory;
import io.trino.spi.security.AccessDeniedException;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class JdkLdapAuthenticatorClient
implements LdapAuthenticatorClient {
    private static final Logger log = Logger.get(JdkLdapAuthenticatorClient.class);
    private final Map<String, String> basicEnvironment;
    private final Optional<SSLContext> sslContext;

    @Inject
    public JdkLdapAuthenticatorClient(LdapConfig ldapConfig) {
        String ldapUrl = Objects.requireNonNull(ldapConfig.getLdapUrl(), "ldapUrl is null");
        if (ldapUrl.startsWith("ldap://")) {
            log.warn("Passwords will be sent in the clear to the LDAP server. Please consider using SSL to connect.");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"java.naming.factory.initial", (Object)"com.sun.jndi.ldap.LdapCtxFactory").put((Object)"java.naming.provider.url", (Object)ldapUrl).put((Object)"java.naming.referral", (Object)(ldapConfig.isIgnoreReferrals() ? "ignore" : "follow"));
        ldapConfig.getLdapConnectionTimeout().map(Duration::toMillis).map(String::valueOf).ifPresent(timeout -> builder.put((Object)"com.sun.jndi.ldap.connect.timeout", timeout));
        ldapConfig.getLdapReadTimeout().map(Duration::toMillis).map(String::valueOf).ifPresent(timeout -> builder.put((Object)"com.sun.jndi.ldap.read.timeout", timeout));
        this.basicEnvironment = builder.buildOrThrow();
        this.sslContext = Optional.ofNullable(ldapConfig.getTrustCertificate()).map(JdkLdapAuthenticatorClient::createSslContext);
    }

    @Override
    public void validatePassword(String userDistinguishedName, String password) throws NamingException {
        this.createUserDirContext(userDistinguishedName, password).close();
    }

    @Override
    public boolean isGroupMember(String searchBase, String groupSearch, String contextUserDistinguishedName, String contextPassword) throws NamingException {
        try (CloseableContext context = this.createUserDirContext(contextUserDistinguishedName, contextPassword);){
            boolean bl;
            block12: {
                CloseableSearchResults search = JdkLdapAuthenticatorClient.searchContext(searchBase, groupSearch, context);
                try {
                    bl = search.hasMore();
                    if (search == null) break block12;
                }
                catch (Throwable throwable) {
                    if (search != null) {
                        try {
                            search.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                search.close();
            }
            return bl;
        }
    }

    @Override
    public Set<String> lookupUserDistinguishedNames(String searchBase, String searchFilter, String contextUserDistinguishedName, String contextPassword) throws NamingException {
        try (CloseableContext context = this.createUserDirContext(contextUserDistinguishedName, contextPassword);){
            ImmutableSet immutableSet;
            block13: {
                CloseableSearchResults search = JdkLdapAuthenticatorClient.searchContext(searchBase, searchFilter, context);
                try {
                    ImmutableSet.Builder distinguishedNames = ImmutableSet.builder();
                    while (search.hasMore()) {
                        distinguishedNames.add((Object)search.next().getNameInNamespace());
                    }
                    immutableSet = distinguishedNames.build();
                    if (search == null) break block13;
                }
                catch (Throwable throwable) {
                    if (search != null) {
                        try {
                            search.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                search.close();
            }
            return immutableSet;
        }
    }

    private static CloseableSearchResults searchContext(String searchBase, String searchFilter, CloseableContext context) throws NamingException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        return new CloseableSearchResults(context.search(searchBase, searchFilter, searchControls));
    }

    private CloseableContext createUserDirContext(String userDistinguishedName, String password) throws NamingException {
        Map<String, String> environment = this.createEnvironment(userDistinguishedName, password);
        try {
            DirContext context = JndiUtils.createDirContext(environment);
            log.debug("Password validation successful for user DN [%s]", new Object[]{userDistinguishedName});
            return new CloseableContext(context);
        }
        catch (AuthenticationException e) {
            log.debug("Password validation failed for user DN [%s]: %s", new Object[]{userDistinguishedName, e.getMessage()});
            throw new AccessDeniedException("Invalid credentials");
        }
    }

    private Map<String, String> createEnvironment(String userDistinguishedName, String password) {
        ImmutableMap.Builder environment = ImmutableMap.builder().putAll(this.basicEnvironment).put((Object)"java.naming.security.authentication", (Object)"simple").put((Object)"java.naming.security.principal", (Object)userDistinguishedName).put((Object)"java.naming.security.credentials", (Object)password);
        this.sslContext.ifPresent(context -> {
            LdapSslSocketFactory.setSslContextForCurrentThread(context);
            environment.put((Object)"java.naming.ldap.factory.socket", (Object)LdapSslSocketFactory.class.getName());
        });
        return environment.buildOrThrow();
    }

    private static SSLContext createSslContext(File trustCertificate) {
        try {
            KeyStore trustStore = PemReader.loadTrustStore((File)trustCertificate);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new RuntimeException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, (TrustManager[])trustManagers, null);
            return sslContext;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CloseableContext
    implements AutoCloseable {
        private final DirContext context;

        public CloseableContext(DirContext context) {
            this.context = Objects.requireNonNull(context, "context is null");
        }

        public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls searchControls) throws NamingException {
            return this.context.search(name, filter, searchControls);
        }

        @Override
        public void close() throws NamingException {
            this.context.close();
        }
    }

    private static class CloseableSearchResults
    implements AutoCloseable {
        private final NamingEnumeration<SearchResult> searchResults;

        public CloseableSearchResults(NamingEnumeration<SearchResult> searchResults) {
            this.searchResults = Objects.requireNonNull(searchResults, "searchResults is null");
        }

        public SearchResult next() throws NamingException {
            return this.searchResults.next();
        }

        public boolean hasMore() throws NamingException {
            return this.searchResults.hasMore();
        }

        @Override
        public void close() throws NamingException {
            this.searchResults.close();
        }
    }
}

