/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.password.ldap;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.Duration;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class LdapConfig {
    private String ldapUrl;
    private boolean allowInsecure;
    private File trustCertificate;
    private List<String> userBindSearchPatterns = ImmutableList.of();
    private String groupAuthorizationSearchPattern;
    private String userBaseDistinguishedName;
    private String bindDistinguishedName;
    private String bindPassword;
    private boolean ignoreReferrals;
    private Duration ldapCacheTtl = new Duration(1.0, TimeUnit.HOURS);

    @NotNull
    @Pattern(regexp="^ldaps?://.*", message="Invalid LDAP server URL. Expected ldap:// or ldaps://")
    public @NotNull @Pattern(regexp="^ldaps?://.*", message="Invalid LDAP server URL. Expected ldap:// or ldaps://") String getLdapUrl() {
        return this.ldapUrl;
    }

    @Config(value="ldap.url")
    @ConfigDescription(value="URL of the LDAP server")
    public LdapConfig setLdapUrl(String url) {
        this.ldapUrl = url;
        return this;
    }

    public boolean isAllowInsecure() {
        return this.allowInsecure;
    }

    @Config(value="ldap.allow-insecure")
    @ConfigDescription(value="Allow insecure connection to the LDAP server")
    public LdapConfig setAllowInsecure(boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
        return this;
    }

    @AssertTrue(message="Connecting to the LDAP server without SSL enabled requires `ldap.allow-insecure=true`")
    public @AssertTrue(message="Connecting to the LDAP server without SSL enabled requires `ldap.allow-insecure=true`") boolean isUrlConfigurationValid() {
        return Strings.nullToEmpty((String)this.ldapUrl).startsWith("ldaps://") || this.allowInsecure;
    }

    @FileExists
    public File getTrustCertificate() {
        return this.trustCertificate;
    }

    @Config(value="ldap.ssl-trust-certificate")
    @ConfigDescription(value="Path to the PEM trust certificate for the LDAP server")
    public LdapConfig setTrustCertificate(File trustCertificate) {
        this.trustCertificate = trustCertificate;
        return this;
    }

    @NotNull
    public List<String> getUserBindSearchPatterns() {
        return this.userBindSearchPatterns;
    }

    public LdapConfig setUserBindSearchPatterns(List<String> userBindSearchPatterns) {
        this.userBindSearchPatterns = Objects.requireNonNull(userBindSearchPatterns, "userBindSearchPatterns is null");
        return this;
    }

    @Config(value="ldap.user-bind-pattern")
    @ConfigDescription(value="Custom user bind pattern. Example: ${USER}@example.com")
    public LdapConfig setUserBindSearchPatterns(String userBindSearchPatterns) {
        this.userBindSearchPatterns = Splitter.on((String)":").trimResults().omitEmptyStrings().splitToList((CharSequence)userBindSearchPatterns);
        return this;
    }

    public String getGroupAuthorizationSearchPattern() {
        return this.groupAuthorizationSearchPattern;
    }

    @Config(value="ldap.group-auth-pattern")
    @ConfigDescription(value="Custom group authorization check query. Example: &(objectClass=user)(memberOf=cn=group)(user=username)")
    public LdapConfig setGroupAuthorizationSearchPattern(String groupAuthorizationSearchPattern) {
        this.groupAuthorizationSearchPattern = groupAuthorizationSearchPattern;
        return this;
    }

    public String getUserBaseDistinguishedName() {
        return this.userBaseDistinguishedName;
    }

    @Config(value="ldap.user-base-dn")
    @ConfigDescription(value="Base distinguished name of the user. Example: dc=example,dc=com")
    public LdapConfig setUserBaseDistinguishedName(String userBaseDistinguishedName) {
        this.userBaseDistinguishedName = userBaseDistinguishedName;
        return this;
    }

    public String getBindDistingushedName() {
        return this.bindDistinguishedName;
    }

    @Config(value="ldap.bind-dn")
    @ConfigDescription(value="Bind distinguished name. Example: CN=User Name,OU=CITY_OU,OU=STATE_OU,DC=domain,DC=domain_root")
    public LdapConfig setBindDistingushedName(String bindDistingushedName) {
        this.bindDistinguishedName = bindDistingushedName;
        return this;
    }

    public String getBindPassword() {
        return this.bindPassword;
    }

    @Config(value="ldap.bind-password")
    @ConfigDescription(value="Bind password used. Example: password1234")
    @ConfigSecuritySensitive
    public LdapConfig setBindPassword(String bindPassword) {
        this.bindPassword = bindPassword;
        return this;
    }

    public boolean isIgnoreReferrals() {
        return this.ignoreReferrals;
    }

    @Config(value="ldap.ignore-referrals")
    @ConfigDescription(value="Referrals allow finding entries across multiple LDAP servers. Ignore them to only search within 1 LDAP server")
    public LdapConfig setIgnoreReferrals(boolean ignoreReferrals) {
        this.ignoreReferrals = ignoreReferrals;
        return this;
    }

    @NotNull
    public Duration getLdapCacheTtl() {
        return this.ldapCacheTtl;
    }

    @Config(value="ldap.cache-ttl")
    public LdapConfig setLdapCacheTtl(Duration ldapCacheTtl) {
        this.ldapCacheTtl = ldapCacheTtl;
        return this;
    }
}

