/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Preconditions;
import io.trino.grammar.type.TypeCalculationBaseVisitor;
import io.trino.grammar.type.TypeCalculationLexer;
import io.trino.grammar.type.TypeCalculationParser;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.tree.NodeLocation;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;

public final class TypeCalculation {
    private static final ANTLRErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new ParsingException(message, e, line, charPositionInLine + 1);
        }
    };

    private TypeCalculation() {
    }

    public static Long calculateLiteralValue(String calculation, Map<String, Long> inputs) {
        try {
            ParserRuleContext tree = TypeCalculation.parseTypeCalculation(calculation);
            CalculateTypeVisitor visitor = new CalculateTypeVisitor(inputs);
            BigInteger result = (BigInteger)visitor.visit((ParseTree)tree);
            return result.longValueExact();
        }
        catch (StackOverflowError e) {
            throw new ParsingException("Type calculation is too large (stack overflow while parsing)", new NodeLocation(1, 1));
        }
    }

    private static ParserRuleContext parseTypeCalculation(String calculation) {
        TypeCalculationParser.TypeCalculationContext tree;
        TypeCalculationLexer lexer = new TypeCalculationLexer((CharStream)CharStreams.fromString((String)calculation));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        TypeCalculationParser parser = new TypeCalculationParser((TokenStream)tokenStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener(ERROR_LISTENER);
        parser.removeErrorListeners();
        parser.addErrorListener(ERROR_LISTENER);
        try {
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            tree = parser.typeCalculation();
        }
        catch (ParsingException ex) {
            tokenStream.seek(0);
            parser.reset();
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            tree = parser.typeCalculation();
        }
        return tree;
    }

    private static class CalculateTypeVisitor
    extends TypeCalculationBaseVisitor<BigInteger> {
        private final Map<String, Long> inputs;

        public CalculateTypeVisitor(Map<String, Long> inputs) {
            this.inputs = Objects.requireNonNull(inputs);
        }

        public BigInteger visitTypeCalculation(TypeCalculationParser.TypeCalculationContext ctx) {
            return (BigInteger)this.visit((ParseTree)ctx.expression());
        }

        public BigInteger visitIfExpression(TypeCalculationParser.IfExpressionContext ctx) {
            BigInteger left = (BigInteger)this.visit((ParseTree)ctx.left);
            BigInteger right = (BigInteger)this.visit((ParseTree)ctx.right);
            boolean condition = switch (ctx.operator.getText()) {
                case ">" -> {
                    if (left.compareTo(right) > 0) {
                        yield true;
                    }
                    yield false;
                }
                case "<" -> {
                    if (left.compareTo(right) < 0) {
                        yield true;
                    }
                    yield false;
                }
                case ">=" -> {
                    if (left.compareTo(right) >= 0) {
                        yield true;
                    }
                    yield false;
                }
                case "<=" -> {
                    if (left.compareTo(right) <= 0) {
                        yield true;
                    }
                    yield false;
                }
                case "=" -> left.equals(right);
                case "!=" -> {
                    if (!left.equals(right)) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new IllegalStateException("Unsupported if operator " + ctx.operator.getText());
            };
            if (condition) {
                return (BigInteger)this.visit((ParseTree)ctx.ifTrue);
            }
            return (BigInteger)this.visit((ParseTree)ctx.ifFalse);
        }

        public BigInteger visitArithmeticBinary(TypeCalculationParser.ArithmeticBinaryContext ctx) {
            BigInteger left = (BigInteger)this.visit((ParseTree)ctx.left);
            BigInteger right = (BigInteger)this.visit((ParseTree)ctx.right);
            return switch (ctx.operator.getType()) {
                case 4 -> left.add(right);
                case 5 -> left.subtract(right);
                case 6 -> left.multiply(right);
                case 7 -> left.divide(right);
                default -> throw new IllegalStateException("Unsupported binary operator " + ctx.operator.getText());
            };
        }

        public BigInteger visitArithmeticUnary(TypeCalculationParser.ArithmeticUnaryContext ctx) {
            BigInteger value = (BigInteger)this.visit((ParseTree)ctx.expression());
            return switch (ctx.operator.getType()) {
                case 4 -> value;
                case 5 -> value.negate();
                default -> throw new IllegalStateException("Unsupported unary operator " + ctx.operator.getText());
            };
        }

        public BigInteger visitBinaryFunction(TypeCalculationParser.BinaryFunctionContext ctx) {
            BigInteger left = (BigInteger)this.visit((ParseTree)ctx.left);
            BigInteger right = (BigInteger)this.visit((ParseTree)ctx.right);
            return switch (ctx.binaryFunctionName().name.getType()) {
                case 9 -> left.min(right);
                case 10 -> left.max(right);
                default -> throw new IllegalArgumentException("Unsupported binary function " + ctx.binaryFunctionName().getText());
            };
        }

        public BigInteger visitNumericLiteral(TypeCalculationParser.NumericLiteralContext ctx) {
            return new BigInteger(ctx.INTEGER_VALUE().getText());
        }

        public BigInteger visitNullLiteral(TypeCalculationParser.NullLiteralContext ctx) {
            return BigInteger.ZERO;
        }

        public BigInteger visitIdentifier(TypeCalculationParser.IdentifierContext ctx) {
            String identifier = ctx.getText();
            Long value = this.inputs.get(identifier);
            Preconditions.checkState((value != null ? 1 : 0) != 0, (String)"value for variable '%s' is not specified in the inputs", (Object)identifier);
            return BigInteger.valueOf(value);
        }

        public BigInteger visitParenthesizedExpression(TypeCalculationParser.ParenthesizedExpressionContext ctx) {
            return (BigInteger)this.visit((ParseTree)ctx.expression());
        }
    }
}

