/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Row
extends Expression {
    private final List<Field> fields;

    @Deprecated
    public Row(List<Field> fields) {
        super(Optional.empty());
        this.fields = ImmutableList.copyOf(fields);
    }

    public Row(NodeLocation location, List<Field> fields) {
        super(location);
        this.fields = ImmutableList.copyOf(fields);
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRow(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.fields;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fields);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Row other = (Row)obj;
        return Objects.equals(this.fields, other.fields);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return Row.sameClass(this, other);
    }

    public static class Field
    extends Node {
        private final Optional<Identifier> name;
        private final Expression expression;

        public Field(NodeLocation location, Optional<Identifier> name, Expression expression) {
            super(location);
            this.name = Objects.requireNonNull(name, "name is null");
            this.expression = Objects.requireNonNull(expression, "expression is null");
        }

        @Deprecated
        public Field(Expression expression) {
            super(Optional.empty());
            this.name = Optional.empty();
            this.expression = Objects.requireNonNull(expression, "expression is null");
        }

        public Optional<Identifier> getName() {
            return this.name;
        }

        public Expression getExpression() {
            return this.expression;
        }

        @Override
        public List<? extends Node> getChildren() {
            ImmutableList.Builder children = ImmutableList.builder();
            this.name.ifPresent(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
            children.add((Object)this.expression);
            return children.build();
        }

        @Override
        protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
            return visitor.visitRowField(this, context);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.name.ifPresent(value -> builder.append(value).append(" "));
            builder.append(this.expression);
            return builder.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Field field = (Field)o;
            return this.name.equals(field.name) && this.expression.equals(field.expression);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.name, this.expression);
        }

        @Override
        public boolean shallowEquals(Node other) {
            return Field.sameClass(this, other);
        }
    }
}

