/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.MergeCase;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MergeInsert
extends MergeCase {
    private final List<Identifier> columns;
    private final List<Expression> values;

    @Deprecated
    public MergeInsert(Optional<Expression> expression, List<Identifier> columns, List<Expression> values) {
        super(Optional.empty(), expression);
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.values = ImmutableList.copyOf((Collection)Objects.requireNonNull(values, "values is null"));
    }

    public MergeInsert(NodeLocation location, Optional<Expression> expression, List<Identifier> columns, List<Expression> values) {
        super(location, expression);
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.values = ImmutableList.copyOf((Collection)Objects.requireNonNull(values, "values is null"));
    }

    public List<Identifier> getColumns() {
        return this.columns;
    }

    public List<Expression> getValues() {
        return this.values;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitMergeInsert(this, context);
    }

    @Override
    public List<Identifier> getSetColumns() {
        return this.columns;
    }

    @Override
    public List<Expression> getSetExpressions() {
        return this.values;
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.expression.ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        builder.addAll(this.columns);
        builder.addAll(this.values);
        return builder.build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression, this.columns, this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MergeInsert o = (MergeInsert)obj;
        return Objects.equals(this.expression, o.expression) && Objects.equals(this.columns, o.columns) && Objects.equals(this.values, o.values);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("expression", this.expression.orElse(null)).add("columns", this.columns).add("values", this.values).omitNullValues().toString();
    }
}

