/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AllRows;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Parameter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Limit
extends Node {
    private final Expression rowCount;

    @Deprecated
    public Limit(Expression rowCount) {
        this(Optional.empty(), rowCount);
    }

    public Limit(NodeLocation location, Expression rowCount) {
        this(Optional.of(location), rowCount);
    }

    private Limit(Optional<NodeLocation> location, Expression rowCount) {
        super(location);
        Preconditions.checkArgument((rowCount instanceof AllRows || rowCount instanceof LongLiteral || rowCount instanceof Parameter ? 1 : 0) != 0, (String)"unexpected rowCount class: %s", (Object)rowCount.getClass().getSimpleName());
        this.rowCount = rowCount;
    }

    public Expression getRowCount() {
        return this.rowCount;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLimit(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.rowCount);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Limit o = (Limit)obj;
        return Objects.equals(this.rowCount, o.rowCount);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rowCount);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("limit", (Object)this.rowCount).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return Limit.sameClass(this, other);
    }
}

