/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.Array;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CurrentCatalog;
import io.trino.sql.tree.CurrentDate;
import io.trino.sql.tree.CurrentPath;
import io.trino.sql.tree.CurrentSchema;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.CurrentTimestamp;
import io.trino.sql.tree.CurrentUser;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.DataTypeParameter;
import io.trino.sql.tree.DateTimeDataType;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.Extract;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.IntervalDayTimeDataType;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.JsonArray;
import io.trino.sql.tree.JsonArrayElement;
import io.trino.sql.tree.JsonExists;
import io.trino.sql.tree.JsonObject;
import io.trino.sql.tree.JsonObjectMember;
import io.trino.sql.tree.JsonPathInvocation;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonValue;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.LocalTime;
import io.trino.sql.tree.LocalTimestamp;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NumericParameter;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowDataType;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.Trim;
import io.trino.sql.tree.TryExpression;
import io.trino.sql.tree.TypeParameter;
import io.trino.sql.tree.WhenClause;
import io.trino.sql.tree.Window;
import io.trino.sql.tree.WindowFrame;
import io.trino.sql.tree.WindowOperation;
import io.trino.sql.tree.WindowReference;
import io.trino.sql.tree.WindowSpecification;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ExpressionTreeRewriter<C> {
    private final ExpressionRewriter<C> rewriter;
    private final AstVisitor<Expression, Context<C>> visitor;

    public static <T extends Expression> T rewriteWith(ExpressionRewriter<Void> rewriter, T node) {
        return new ExpressionTreeRewriter<Void>(rewriter).rewrite(node, null);
    }

    public static <C, T extends Expression> T rewriteWith(ExpressionRewriter<C> rewriter, T node, C context) {
        return new ExpressionTreeRewriter<C>(rewriter).rewrite(node, context);
    }

    public ExpressionTreeRewriter(ExpressionRewriter<C> rewriter) {
        this.rewriter = rewriter;
        this.visitor = new RewritingVisitor(this);
    }

    private List<Expression> rewrite(List<Expression> items, Context<C> context) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Expression expression : items) {
            builder.add((Object)this.rewrite(expression, context.get()));
        }
        return builder.build();
    }

    public <T extends Expression> T rewrite(T node, C context) {
        return (T)this.visitor.process(node, new Context<C>(context, false));
    }

    public <T extends Expression> T defaultRewrite(T node, C context) {
        return (T)this.visitor.process(node, new Context<C>(context, true));
    }

    private static <T> boolean sameElements(Optional<T> a, Optional<T> b) {
        if (!a.isPresent() && !b.isPresent()) {
            return true;
        }
        if (a.isPresent() != b.isPresent()) {
            return false;
        }
        return a.get() == b.get();
    }

    private static <T> boolean sameElements(Iterable<? extends T> a, Iterable<? extends T> b) {
        if (Iterables.size(a) != Iterables.size(b)) {
            return false;
        }
        Iterator<T> first = a.iterator();
        Iterator<T> second = b.iterator();
        while (first.hasNext() && second.hasNext()) {
            if (first.next() == second.next()) continue;
            return false;
        }
        return true;
    }

    private class RewritingVisitor
    extends AstVisitor<Expression, Context<C>> {
        final /* synthetic */ ExpressionTreeRewriter this$0;

        private RewritingVisitor(ExpressionTreeRewriter expressionTreeRewriter) {
            ExpressionTreeRewriter expressionTreeRewriter2 = expressionTreeRewriter;
            Objects.requireNonNull(expressionTreeRewriter2);
            this.this$0 = expressionTreeRewriter2;
        }

        @Override
        protected Expression visitExpression(Expression node, Context<C> context) {
            throw new UnsupportedOperationException("visit() not implemented for " + node.getClass().getName());
        }

        @Override
        protected Expression visitRow(Row node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteRow(node, context.get(), this.this$0)) != null) {
                return result;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Row.Field field : node.getFields()) {
                builder.add((Object)new Row.Field(field.getLocation().orElseThrow(), field.getName(), this.this$0.rewrite(field.getExpression(), context.get())));
            }
            ImmutableList fields = builder.build();
            if (!ExpressionTreeRewriter.sameElements(node.getFields(), fields)) {
                return new Row(node.getLocation().orElseThrow(), (List<Row.Field>)fields);
            }
            return node;
        }

        @Override
        protected Expression visitArithmeticUnary(ArithmeticUnaryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteArithmeticUnary(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression child = this.this$0.rewrite(node.getValue(), context.get());
            if (child != node.getValue()) {
                return new ArithmeticUnaryExpression(node.getLocation().orElseThrow(), node.getSign(), child);
            }
            return node;
        }

        @Override
        public Expression visitArithmeticBinary(ArithmeticBinaryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteArithmeticBinary(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression left = this.this$0.rewrite(node.getLeft(), context.get());
            Expression right = this.this$0.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new ArithmeticBinaryExpression(node.getLocation().orElseThrow(), node.getOperator(), left, right);
            }
            return node;
        }

        @Override
        protected Expression visitArray(Array node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteArray(node, context.get(), this.this$0)) != null) {
                return result;
            }
            List<Expression> values = this.this$0.rewrite(node.getValues(), context);
            if (!ExpressionTreeRewriter.sameElements(node.getValues(), values)) {
                return new Array(node.getLocation().orElseThrow(), values);
            }
            return node;
        }

        @Override
        protected Expression visitAtTimeZone(AtTimeZone node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteAtTimeZone(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression value = this.this$0.rewrite(node.getValue(), context.get());
            Expression timeZone = this.this$0.rewrite(node.getTimeZone(), context.get());
            if (value != node.getValue() || timeZone != node.getTimeZone()) {
                return new AtTimeZone(node.getLocation().orElseThrow(), value, timeZone);
            }
            return node;
        }

        @Override
        protected Expression visitSubscriptExpression(SubscriptExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteSubscriptExpression(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression base = this.this$0.rewrite(node.getBase(), context.get());
            Expression index = this.this$0.rewrite(node.getIndex(), context.get());
            if (base != node.getBase() || index != node.getIndex()) {
                return new SubscriptExpression(node.getLocation().orElseThrow(), base, index);
            }
            return node;
        }

        @Override
        public Expression visitComparisonExpression(ComparisonExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteComparisonExpression(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression left = this.this$0.rewrite(node.getLeft(), context.get());
            Expression right = this.this$0.rewrite(node.getRight(), context.get());
            if (left != node.getLeft() || right != node.getRight()) {
                return new ComparisonExpression(node.getLocation().orElseThrow(), node.getOperator(), left, right);
            }
            return node;
        }

        @Override
        protected Expression visitBetweenPredicate(BetweenPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteBetweenPredicate(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression value = this.this$0.rewrite(node.getValue(), context.get());
            Expression min = this.this$0.rewrite(node.getMin(), context.get());
            Expression max = this.this$0.rewrite(node.getMax(), context.get());
            if (value != node.getValue() || min != node.getMin() || max != node.getMax()) {
                return new BetweenPredicate(node.getLocation().orElseThrow(), value, min, max);
            }
            return node;
        }

        @Override
        public Expression visitLogicalExpression(LogicalExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteLogicalExpression(node, context.get(), this.this$0)) != null) {
                return result;
            }
            List<Expression> terms = this.this$0.rewrite(node.getTerms(), context);
            if (!ExpressionTreeRewriter.sameElements(node.getTerms(), terms)) {
                return new LogicalExpression(node.getLocation().orElseThrow(), node.getOperator(), terms);
            }
            return node;
        }

        @Override
        public Expression visitNotExpression(NotExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteNotExpression(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression value = this.this$0.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new NotExpression(node.getLocation().orElseThrow(), value);
            }
            return node;
        }

        @Override
        protected Expression visitIsNullPredicate(IsNullPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteIsNullPredicate(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression value = this.this$0.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new IsNullPredicate(node.getLocation().orElseThrow(), value);
            }
            return node;
        }

        @Override
        protected Expression visitIsNotNullPredicate(IsNotNullPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteIsNotNullPredicate(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression value = this.this$0.rewrite(node.getValue(), context.get());
            if (value != node.getValue()) {
                return new IsNotNullPredicate(node.getLocation().orElseThrow(), value);
            }
            return node;
        }

        @Override
        protected Expression visitNullIfExpression(NullIfExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteNullIfExpression(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression first = this.this$0.rewrite(node.getFirst(), context.get());
            Expression second = this.this$0.rewrite(node.getSecond(), context.get());
            if (first != node.getFirst() || second != node.getSecond()) {
                return new NullIfExpression(node.getLocation().orElseThrow(), first, second);
            }
            return node;
        }

        @Override
        protected Expression visitIfExpression(IfExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteIfExpression(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression condition = this.this$0.rewrite(node.getCondition(), context.get());
            Expression trueValue = this.this$0.rewrite(node.getTrueValue(), context.get());
            Expression falseValue = null;
            if (node.getFalseValue().isPresent()) {
                falseValue = this.this$0.rewrite(node.getFalseValue().get(), context.get());
            }
            if (condition != node.getCondition() || trueValue != node.getTrueValue() || falseValue != node.getFalseValue().orElse(null)) {
                return new IfExpression(node.getLocation().orElseThrow(), condition, trueValue, falseValue);
            }
            return node;
        }

        @Override
        protected Expression visitSearchedCaseExpression(SearchedCaseExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteSearchedCaseExpression(node, context.get(), this.this$0)) != null) {
                return result;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression : node.getWhenClauses()) {
                builder.add((Object)this.this$0.rewrite(expression, context.get()));
            }
            Optional<Expression> defaultValue = node.getDefaultValue().map(value -> this.this$0.rewrite(value, context.get()));
            if (!ExpressionTreeRewriter.sameElements(node.getDefaultValue(), defaultValue) || !ExpressionTreeRewriter.sameElements(node.getWhenClauses(), builder.build())) {
                return new SearchedCaseExpression(node.getLocation().orElseThrow(), (List<WhenClause>)builder.build(), defaultValue);
            }
            return node;
        }

        @Override
        protected Expression visitSimpleCaseExpression(SimpleCaseExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteSimpleCaseExpression(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression operand = this.this$0.rewrite(node.getOperand(), context.get());
            ImmutableList.Builder builder = ImmutableList.builder();
            for (WhenClause expression : node.getWhenClauses()) {
                builder.add((Object)this.this$0.rewrite(expression, context.get()));
            }
            Optional<Expression> defaultValue = node.getDefaultValue().map(value -> this.this$0.rewrite(value, context.get()));
            if (operand != node.getOperand() || !ExpressionTreeRewriter.sameElements(node.getDefaultValue(), defaultValue) || !ExpressionTreeRewriter.sameElements(node.getWhenClauses(), builder.build())) {
                return new SimpleCaseExpression(node.getLocation().orElseThrow(), operand, (List<WhenClause>)builder.build(), defaultValue);
            }
            return node;
        }

        @Override
        protected Expression visitWhenClause(WhenClause node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteWhenClause(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression operand = this.this$0.rewrite(node.getOperand(), context.get());
            Expression result2 = this.this$0.rewrite(node.getResult(), context.get());
            if (operand != node.getOperand() || result2 != node.getResult()) {
                return new WhenClause(node.getLocation().orElseThrow(), operand, result2);
            }
            return node;
        }

        @Override
        protected Expression visitCoalesceExpression(CoalesceExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteCoalesceExpression(node, context.get(), this.this$0)) != null) {
                return result;
            }
            List<Expression> operands = this.this$0.rewrite(node.getOperands(), context);
            if (!ExpressionTreeRewriter.sameElements(node.getOperands(), operands)) {
                return new CoalesceExpression(node.getLocation().orElseThrow(), operands);
            }
            return node;
        }

        @Override
        public Expression visitTryExpression(TryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteTryExpression(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression expression = this.this$0.rewrite(node.getInnerExpression(), context.get());
            if (node.getInnerExpression() != expression) {
                return new TryExpression(node.getLocation().orElseThrow(), expression);
            }
            return node;
        }

        @Override
        public Expression visitFunctionCall(FunctionCall node, Context<C> context) {
            OrderBy rewrittenOrderBy;
            Window rewrittenWindow;
            Optional<Window> window;
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteFunctionCall(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Optional<Expression> filter = node.getFilter();
            if (filter.isPresent()) {
                Expression filterExpression = filter.get();
                Expression newFilterExpression = this.this$0.rewrite(filterExpression, context.get());
                filter = Optional.of(newFilterExpression);
            }
            if ((window = node.getWindow()).isPresent() && (rewrittenWindow = this.rewriteWindow(window.get(), context)) != window.get()) {
                window = Optional.of(rewrittenWindow);
            }
            List<Expression> arguments = this.this$0.rewrite(node.getArguments(), context);
            Optional<OrderBy> orderBy = node.getOrderBy();
            if (orderBy.isPresent() && (rewrittenOrderBy = this.rewriteOrderBy(orderBy.get(), context)) != orderBy.get()) {
                orderBy = Optional.of(rewrittenOrderBy);
            }
            if (!(ExpressionTreeRewriter.sameElements(node.getArguments(), arguments) && ExpressionTreeRewriter.sameElements(window, node.getWindow()) && ExpressionTreeRewriter.sameElements(filter, node.getFilter()) && ExpressionTreeRewriter.sameElements(orderBy, node.getOrderBy()))) {
                return new FunctionCall(node.getLocation(), node.getName(), window, filter, orderBy, node.isDistinct(), node.getNullTreatment(), node.getProcessingMode(), arguments);
            }
            return node;
        }

        private OrderBy rewriteOrderBy(OrderBy orderBy, Context<C> context) {
            List<SortItem> rewrittenSortItems = this.rewriteSortItems(orderBy.getSortItems(), context);
            if (ExpressionTreeRewriter.sameElements(orderBy.getSortItems(), rewrittenSortItems)) {
                return orderBy;
            }
            return new OrderBy(orderBy.getLocation().orElseThrow(), rewrittenSortItems);
        }

        private List<SortItem> rewriteSortItems(List<SortItem> sortItems, Context<C> context) {
            ImmutableList.Builder rewrittenSortItems = ImmutableList.builder();
            for (SortItem sortItem : sortItems) {
                Expression sortKey = this.this$0.rewrite(sortItem.getSortKey(), context.get());
                if (sortItem.getSortKey() != sortKey) {
                    rewrittenSortItems.add((Object)new SortItem(sortItem.getLocation().orElseThrow(), sortKey, sortItem.getOrdering(), sortItem.getNullOrdering()));
                    continue;
                }
                rewrittenSortItems.add((Object)sortItem);
            }
            return rewrittenSortItems.build();
        }

        private Window rewriteWindow(Window window, Context<C> context) {
            Optional<WindowFrame> rewrittenFrame;
            if (window instanceof WindowReference) {
                WindowReference windowReference = (WindowReference)window;
                Identifier rewrittenName = this.this$0.rewrite(windowReference.getName(), context.get());
                if (windowReference.getName() != rewrittenName) {
                    return new WindowReference(rewrittenName);
                }
                return window;
            }
            WindowSpecification windowSpecification = (WindowSpecification)window;
            Optional<Identifier> existingWindowName = windowSpecification.getExistingWindowName().map(name -> this.this$0.rewrite(name, context.get()));
            List<Expression> partitionBy = this.this$0.rewrite(windowSpecification.getPartitionBy(), context);
            Optional<OrderBy> orderBy = Optional.empty();
            if (windowSpecification.getOrderBy().isPresent()) {
                orderBy = Optional.of(this.rewriteOrderBy(windowSpecification.getOrderBy().get(), context));
            }
            if ((rewrittenFrame = windowSpecification.getFrame()).isPresent()) {
                Expression rewrittenValue;
                Optional<Expression> value;
                Optional<FrameBound> rewrittenEnd;
                Expression value2;
                WindowFrame frame = rewrittenFrame.get();
                FrameBound start = frame.getStart();
                if (start.getValue().isPresent() && (value2 = this.this$0.rewrite(start.getValue().get(), context.get())) != start.getValue().get()) {
                    start = new FrameBound(start.getType(), value2);
                }
                if ((rewrittenEnd = frame.getEnd()).isPresent() && (value = rewrittenEnd.get().getValue()).isPresent() && (rewrittenValue = this.this$0.rewrite(value.get(), context.get())) != value.get()) {
                    rewrittenEnd = Optional.of(new FrameBound(rewrittenEnd.get().getType(), rewrittenValue));
                }
                if (!frame.getMeasures().isEmpty() || frame.getAfterMatchSkipTo().isPresent() || frame.getPatternSearchMode().isPresent() || frame.getPattern().isPresent() || !frame.getSubsets().isEmpty() || !frame.getVariableDefinitions().isEmpty()) {
                    throw new UnsupportedOperationException("cannot rewrite pattern recognition clauses in window");
                }
                if (frame.getStart() != start || !ExpressionTreeRewriter.sameElements(frame.getEnd(), rewrittenEnd)) {
                    rewrittenFrame = Optional.of(new WindowFrame(frame.getType(), start, rewrittenEnd, frame.getMeasures(), frame.getAfterMatchSkipTo(), frame.getPatternSearchMode(), frame.getPattern(), frame.getSubsets(), frame.getVariableDefinitions()));
                }
            }
            if (!(ExpressionTreeRewriter.sameElements(windowSpecification.getExistingWindowName(), existingWindowName) && ExpressionTreeRewriter.sameElements(windowSpecification.getPartitionBy(), partitionBy) && ExpressionTreeRewriter.sameElements(windowSpecification.getOrderBy(), orderBy) && ExpressionTreeRewriter.sameElements(windowSpecification.getFrame(), rewrittenFrame))) {
                return new WindowSpecification(existingWindowName, partitionBy, orderBy, rewrittenFrame);
            }
            return window;
        }

        @Override
        protected Expression visitWindowOperation(WindowOperation node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteWindowOperation(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Identifier name = this.this$0.rewrite(node.getName(), context.get());
            Window window = this.rewriteWindow(node.getWindow(), context);
            if (name != node.getName() || window != node.getWindow()) {
                return new WindowOperation(node.getLocation().orElseThrow(), name, window);
            }
            return node;
        }

        @Override
        protected Expression visitLambdaExpression(LambdaExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteLambdaExpression(node, context.get(), this.this$0)) != null) {
                return result;
            }
            List arguments = (List)node.getArguments().stream().map(LambdaArgumentDeclaration::getName).map(expression -> this.this$0.rewrite(expression, context.get())).map(LambdaArgumentDeclaration::new).collect(ImmutableList.toImmutableList());
            Expression body = this.this$0.rewrite(node.getBody(), context.get());
            if (body != node.getBody()) {
                return new LambdaExpression(node.getLocation().orElseThrow(), (List<LambdaArgumentDeclaration>)arguments, body);
            }
            return node;
        }

        @Override
        public Expression visitLikePredicate(LikePredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteLikePredicate(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression value = this.this$0.rewrite(node.getValue(), context.get());
            Expression pattern = this.this$0.rewrite(node.getPattern(), context.get());
            Optional<Expression> rewrittenEscape = node.getEscape().map(escape -> this.this$0.rewrite(escape, context.get()));
            if (value != node.getValue() || pattern != node.getPattern() || !ExpressionTreeRewriter.sameElements(node.getEscape(), rewrittenEscape)) {
                return new LikePredicate(node.getLocation().orElseThrow(), value, pattern, rewrittenEscape);
            }
            return node;
        }

        @Override
        public Expression visitInPredicate(InPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteInPredicate(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression value = this.this$0.rewrite(node.getValue(), context.get());
            Expression list = this.this$0.rewrite(node.getValueList(), context.get());
            if (node.getValue() != value || node.getValueList() != list) {
                return new InPredicate(node.getLocation().orElseThrow(), value, list);
            }
            return node;
        }

        @Override
        protected Expression visitInListExpression(InListExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteInListExpression(node, context.get(), this.this$0)) != null) {
                return result;
            }
            List<Expression> values = this.this$0.rewrite(node.getValues(), context);
            if (!ExpressionTreeRewriter.sameElements(node.getValues(), values)) {
                return new InListExpression(node.getLocation().orElseThrow(), values);
            }
            return node;
        }

        @Override
        protected Expression visitExists(ExistsPredicate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteExists(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression subquery = node.getSubquery();
            if ((subquery = this.this$0.rewrite(subquery, context.get())) != node.getSubquery()) {
                return new ExistsPredicate(node.getLocation().orElseThrow(), subquery);
            }
            return node;
        }

        @Override
        public Expression visitSubqueryExpression(SubqueryExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteSubqueryExpression(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitLiteral(Literal node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteLiteral(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitParameter(Parameter node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteParameter(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitIdentifier(Identifier node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteIdentifier(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitDereferenceExpression(DereferenceExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteDereferenceExpression(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression base = this.this$0.rewrite(node.getBase(), context.get());
            if (base != node.getBase()) {
                if (node.getField().isPresent()) {
                    return new DereferenceExpression(base, node.getField().get());
                }
                return new DereferenceExpression((Identifier)base);
            }
            return node;
        }

        @Override
        protected Expression visitExtract(Extract node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteExtract(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression expression = this.this$0.rewrite(node.getExpression(), context.get());
            if (node.getExpression() != expression) {
                return new Extract(node.getLocation().orElseThrow(), expression, node.getField());
            }
            return node;
        }

        @Override
        protected Expression visitCurrentDate(CurrentDate node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteCurrentDate(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitCurrentTime(CurrentTime node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteCurrentTime(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitCurrentTimestamp(CurrentTimestamp node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteCurrentTimestamp(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitLocalTimestamp(LocalTimestamp node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteLocalTimestamp(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitLocalTime(LocalTime node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteLocalTime(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        public Expression visitCast(Cast node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteCast(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression expression = this.this$0.rewrite(node.getExpression(), context.get());
            DataType type = this.this$0.rewrite(node.getType(), context.get());
            if (node.getExpression() != expression || node.getType() != type) {
                return new Cast(node.getLocation().orElseThrow(), expression, type, node.isSafe());
            }
            return node;
        }

        @Override
        protected Expression visitRowDataType(RowDataType node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteRowDataType(node, context.get(), this.this$0)) != null) {
                return result;
            }
            ImmutableList.Builder rewritten = ImmutableList.builder();
            for (RowDataType.Field field : node.getFields()) {
                boolean nameRewritten;
                Identifier rewrittenIdentifier;
                Identifier identifier;
                DataType dataType = this.this$0.rewrite(field.getType(), context.get());
                Optional<Identifier> name = field.getName();
                if (field.getName().isPresent() && (identifier = field.getName().get()) != (rewrittenIdentifier = this.this$0.rewrite(identifier, context.get()))) {
                    name = Optional.of(rewrittenIdentifier);
                }
                boolean bl = nameRewritten = name != field.getName();
                if (dataType != field.getType() || nameRewritten) {
                    rewritten.add((Object)new RowDataType.Field(field.getLocation().orElseThrow(), name, dataType));
                    continue;
                }
                rewritten.add((Object)field);
            }
            ImmutableList fields = rewritten.build();
            if (!ExpressionTreeRewriter.sameElements(fields, node.getFields())) {
                return new RowDataType(node.getLocation(), (List<RowDataType.Field>)fields);
            }
            return node;
        }

        @Override
        protected Expression visitGenericDataType(GenericDataType node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteGenericDataType(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Identifier name = this.this$0.rewrite(node.getName(), context.get());
            ImmutableList.Builder arguments = ImmutableList.builder();
            for (DataTypeParameter argument : node.getArguments()) {
                if (argument instanceof NumericParameter) {
                    arguments.add((Object)argument);
                    continue;
                }
                if (!(argument instanceof TypeParameter)) continue;
                TypeParameter parameter = (TypeParameter)argument;
                DataType value = (DataType)this.process(parameter.getValue(), context);
                if (value != parameter.getValue()) {
                    arguments.add((Object)new TypeParameter(value));
                    continue;
                }
                arguments.add((Object)argument);
            }
            ImmutableList rewrittenArguments = arguments.build();
            if (name != node.getName() || !ExpressionTreeRewriter.sameElements(rewrittenArguments, node.getArguments())) {
                return new GenericDataType(node.getLocation(), name, (List<DataTypeParameter>)rewrittenArguments);
            }
            return node;
        }

        @Override
        protected Expression visitIntervalDataType(IntervalDayTimeDataType node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteIntervalDayTimeDataType(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitDateTimeType(DateTimeDataType node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteDateTimeDataType(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitFieldReference(FieldReference node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteFieldReference(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteQuantifiedComparison(node, context.get(), this.this$0)) != null) {
                return result;
            }
            Expression value = this.this$0.rewrite(node.getValue(), context.get());
            Expression subquery = this.this$0.rewrite(node.getSubquery(), context.get());
            if (node.getValue() != value || node.getSubquery() != subquery) {
                return new QuantifiedComparisonExpression(node.getLocation().orElseThrow(), node.getOperator(), node.getQuantifier(), value, subquery);
            }
            return node;
        }

        @Override
        public Expression visitGroupingOperation(GroupingOperation node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteGroupingOperation(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitCurrentCatalog(CurrentCatalog node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteCurrentCatalog(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitCurrentSchema(CurrentSchema node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteCurrentSchema(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitCurrentUser(CurrentUser node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteCurrentUser(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitCurrentPath(CurrentPath node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteCurrentPath(node, context.get(), this.this$0)) != null) {
                return result;
            }
            return node;
        }

        @Override
        protected Expression visitTrim(Trim node, Context<C> context) {
            Optional<Expression> trimChar;
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteTrim(node, context.get(), this.this$0)) != null) {
                return result;
            }
            ImmutableList.Builder expressions = ImmutableList.builder();
            expressions.add((Object)node.getTrimSource());
            node.getTrimCharacter().ifPresent(arg_0 -> ((ImmutableList.Builder)expressions).add(arg_0));
            Expression trimSource = this.this$0.rewrite(node.getTrimSource(), context.get());
            Optional<Expression> optional = trimChar = node.getTrimCharacter().isPresent() ? Optional.of(this.this$0.rewrite(node.getTrimCharacter().get(), context.get())) : Optional.empty();
            if (trimSource != node.getTrimSource() || !ExpressionTreeRewriter.sameElements(trimChar, node.getTrimCharacter())) {
                return new Trim(node.getLocation().orElseThrow(), node.getSpecification(), trimSource, trimChar);
            }
            return node;
        }

        @Override
        protected Expression visitFormat(Format node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteFormat(node, context.get(), this.this$0)) != null) {
                return result;
            }
            List<Expression> arguments = this.this$0.rewrite(node.getArguments(), context);
            if (!ExpressionTreeRewriter.sameElements(node.getArguments(), arguments)) {
                return new Format(node.getLocation().orElseThrow(), arguments);
            }
            return node;
        }

        @Override
        protected Expression visitJsonExists(JsonExists node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteJsonExists(node, context.get(), this.this$0)) != null) {
                return result;
            }
            JsonPathInvocation jsonPathInvocation = this.rewriteJsonPathInvocation(node.getJsonPathInvocation(), context);
            if (node.getJsonPathInvocation() != jsonPathInvocation) {
                return new JsonExists(node.getLocation().orElseThrow(), jsonPathInvocation, node.getErrorBehavior());
            }
            return node;
        }

        @Override
        protected Expression visitJsonValue(JsonValue node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteJsonValue(node, context.get(), this.this$0)) != null) {
                return result;
            }
            JsonPathInvocation jsonPathInvocation = this.rewriteJsonPathInvocation(node.getJsonPathInvocation(), context);
            Optional<Expression> emptyDefault = node.getEmptyDefault().map(expression -> this.this$0.rewrite(expression, context.get()));
            Optional<Expression> errorDefault = node.getErrorDefault().map(expression -> this.this$0.rewrite(expression, context.get()));
            if (node.getJsonPathInvocation() != jsonPathInvocation || !ExpressionTreeRewriter.sameElements(node.getEmptyDefault(), emptyDefault) || !ExpressionTreeRewriter.sameElements(node.getErrorDefault(), errorDefault)) {
                return new JsonValue(node.getLocation().orElseThrow(), jsonPathInvocation, node.getReturnedType(), node.getEmptyBehavior(), emptyDefault, node.getErrorBehavior(), errorDefault);
            }
            return node;
        }

        @Override
        protected Expression visitJsonQuery(JsonQuery node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteJsonQuery(node, context.get(), this.this$0)) != null) {
                return result;
            }
            JsonPathInvocation jsonPathInvocation = this.rewriteJsonPathInvocation(node.getJsonPathInvocation(), context);
            if (node.getJsonPathInvocation() != jsonPathInvocation) {
                return new JsonQuery(node.getLocation().orElseThrow(), jsonPathInvocation, node.getReturnedType(), node.getOutputFormat(), node.getWrapperBehavior(), node.getQuotesBehavior(), node.getEmptyBehavior(), node.getErrorBehavior());
            }
            return node;
        }

        @Override
        protected Expression visitJsonObject(JsonObject node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteJsonObject(node, context.get(), this.this$0)) != null) {
                return result;
            }
            List members = (List)node.getMembers().stream().map(member -> {
                Expression key = this.this$0.rewrite(member.getKey(), context.get());
                Expression value = this.this$0.rewrite(member.getValue(), context.get());
                if (member.getKey() == key && member.getValue() == value) {
                    return member;
                }
                return new JsonObjectMember(member.getLocation().orElseThrow(), key, value, member.getFormat());
            }).collect(ImmutableList.toImmutableList());
            if (!ExpressionTreeRewriter.sameElements(node.getMembers(), members)) {
                return new JsonObject(node.getLocation().orElseThrow(), members, node.isNullOnNull(), node.isUniqueKeys(), node.getReturnedType(), node.getOutputFormat());
            }
            return node;
        }

        @Override
        protected Expression visitJsonArray(JsonArray node, Context<C> context) {
            Expression result;
            if (!context.isDefaultRewrite() && (result = this.this$0.rewriter.rewriteJsonArray(node, context.get(), this.this$0)) != null) {
                return result;
            }
            List elements = (List)node.getElements().stream().map(element -> {
                Expression value = this.this$0.rewrite(element.getValue(), context.get());
                if (element.getValue() == value) {
                    return element;
                }
                return new JsonArrayElement(element.getLocation().orElseThrow(), value, element.getFormat());
            }).collect(ImmutableList.toImmutableList());
            if (!ExpressionTreeRewriter.sameElements(node.getElements(), elements)) {
                return new JsonArray(node.getLocation().orElseThrow(), elements, node.isNullOnNull(), node.getReturnedType(), node.getOutputFormat());
            }
            return node;
        }

        private JsonPathInvocation rewriteJsonPathInvocation(JsonPathInvocation pathInvocation, Context<C> context) {
            Expression inputExpression = this.this$0.rewrite(pathInvocation.getInputExpression(), context.get());
            List pathParameters = (List)pathInvocation.getPathParameters().stream().map(pathParameter -> {
                Expression expression = this.this$0.rewrite(pathParameter.getParameter(), context.get());
                if (pathParameter.getParameter() != expression) {
                    return new JsonPathParameter(pathParameter.getLocation().orElseThrow(), pathParameter.getName(), expression, pathParameter.getFormat());
                }
                return pathParameter;
            }).collect(ImmutableList.toImmutableList());
            if (pathInvocation.getInputExpression() != inputExpression || !ExpressionTreeRewriter.sameElements(pathInvocation.getPathParameters(), pathParameters)) {
                return new JsonPathInvocation(pathInvocation.getLocation().orElseThrow(), inputExpression, pathInvocation.getInputFormat(), pathInvocation.getJsonPath(), pathInvocation.getPathName(), pathParameters);
            }
            return pathInvocation;
        }
    }

    public static class Context<C> {
        private final boolean defaultRewrite;
        private final C context;

        private Context(C context, boolean defaultRewrite) {
            this.context = context;
            this.defaultRewrite = defaultRewrite;
        }

        public C get() {
            return this.context;
        }

        public boolean isDefaultRewrite() {
            return this.defaultRewrite;
        }
    }
}

