/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Corresponding;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QueryBody;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.SetOperation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Except
extends SetOperation {
    private final QueryBody left;
    private final QueryBody right;

    public Except(NodeLocation location, QueryBody left, QueryBody right, boolean distinct, Optional<Corresponding> corresponding) {
        super(Optional.of(location), distinct, corresponding);
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        this.left = left;
        this.right = right;
    }

    public Relation getLeft() {
        return this.left;
    }

    public Relation getRight() {
        return this.right;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExcept(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    public List<Relation> getRelations() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("left", (Object)this.left).add("right", (Object)this.right).add("distinct", this.isDistinct()).add("corresponding", this.getCorresponding()).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Except o = (Except)obj;
        return Objects.equals(this.left, o.left) && Objects.equals(this.right, o.right) && this.isDistinct() == o.isDistinct() && Objects.equals(this.getCorresponding(), o.getCorresponding());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left, this.right, this.isDistinct(), this.getCorresponding());
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Except.sameClass(this, other)) {
            return false;
        }
        Except otherExcept = (Except)other;
        return this.isDistinct() == otherExcept.isDistinct() && Objects.equals(this.getCorresponding(), otherExcept.getCorresponding());
    }
}

