/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;

public class DropDefaultValue
extends Statement {
    private final QualifiedName tableName;
    private final QualifiedName columnName;
    private final boolean tableExists;

    public DropDefaultValue(NodeLocation location, QualifiedName tableName, QualifiedName columnName, boolean tableExists) {
        super(location);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.tableExists = tableExists;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public QualifiedName getColumnName() {
        return this.columnName;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropDefaultValue(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.columnName, this.tableExists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropDefaultValue o = (DropDefaultValue)obj;
        return Objects.equals(this.tableName, o.tableName) && Objects.equals(this.columnName, o.columnName) && this.tableExists == o.tableExists;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.tableName).add("column", (Object)this.columnName).add("tableExists", this.tableExists).toString();
    }
}

